package ru.yandex.autotests.direct.web.pages.showcampbem.blocks.banners;

import com.google.common.base.CharMatcher;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.objects.banners.BannerInfoWeb;
import ru.yandex.autotests.direct.web.objects.banners.MobileAppBannerInfoWeb;
import ru.yandex.autotests.direct.web.webelements.bem.TumblerBEM;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.HtmlElement;

/**
 * Created by aleran on 12.10.2015.
 */
public class BannerGroupPreviewItemBlock extends HtmlElement {

    @Name("Тумблер 'Вкл/Откл'")
    @FindBy(xpath = ".//span[contains(@class, 'shown-status')]//input")
    private TumblerBEM onOffTumbler;

    @Name("Номер объявления")
    @FindBy(xpath = ".//div[contains(@class, 'banner-title-bid')]")
    private WebElement bannerBid;

    @Name("Кнопка 'Удалить'")
    @FindBy(xpath = ".//button[contains(@class, 'delete')]")
    private Button removeButton;

    @Name("Кнопка 'Архивировать'")
    @FindBy(xpath = ".//button[contains(@class, 'archive') and not(contains(@class, 'unarchive'))]")
    private Button archiveButton;

    @Name("Кнопка 'Разархивировать'")
    @FindBy(xpath = ".//button[contains(@class, 'unarchive')]")
    private Button unArchiveButton;

    @Name("Текстовое объявление")
    @FindBy(css = "div.b-banner-preview2_view_base")
    private BannerPreviewContentPopupBlock bannerGroupPreviewContentBlock;

    @Name("Объявление мобильных приложений")
    @FindBy(css = "div.b-banner-preview2_view_mobile-content-campaign")
    private MobileAppBannerPreviewContentPopupBlock mobileAppBannerPreviewContentPopupBlock;

    public String getNumber() {
        return CharMatcher.inRange('0', '9').retainFrom(bannerBid.getText());
    }

    public void clickRemoveButton() {
        removeButton.click();
    }

    public void selectTumbler(Boolean status) {
        onOffTumbler.set(status);
    }

    public Boolean getTumblerStatus() {
        return onOffTumbler.isSelected();
    }

    public void clickArchiveButton() {
        archiveButton.click();
    }

    public void clickUnArchiveButton() {
        unArchiveButton.click();
    }

    public void checkMobileAppBannerParameters(MobileAppBannerInfoWeb expectedBean) {
        mobileAppBannerPreviewContentPopupBlock.checkParameters(expectedBean);
    }

    public void checkBannerParameters(BannerInfoWeb expectedBean) {
        bannerGroupPreviewContentBlock.checkParameters(expectedBean);
    }
}
