package ru.yandex.autotests.direct.web.pages.showcampbem.blocks.banners;

import org.hamcrest.Matcher;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import ru.yandex.autotests.direct.web.data.BannerPreviewType;
import ru.yandex.autotests.direct.web.data.RadioInputMethod;
import ru.yandex.autotests.direct.web.objects.banners.BannerInfoWeb;
import ru.yandex.autotests.direct.web.objects.banners.MobileAppBannerInfoWeb;
import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.autotests.direct.web.util.matchers.IsDisplayedMatcher;
import ru.yandex.autotests.direct.web.webelements.bem.RadioBEM;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.Link;

import java.util.List;

import static org.hamcrest.Matchers.not;
import static org.junit.Assert.assertThat;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillRadio;
import static ru.yandex.qatools.htmlelements.matchers.MatcherDecorators.should;
import static ru.yandex.qatools.htmlelements.matchers.MatcherDecorators.timeoutHasExpired;

/**
 * Created by proxeter (Nikolay Mulyar - proxeter@yandex-team.ru) on 21.05.2014.
 */
@FindBy(xpath = ".//div[contains(@class, 'group-preview')][contains(@class, 'popup_visibility_visible')]")
public class BannerGroupPreviewPopupBlock extends HtmlElement {

    @Name("Крестик для закрытия всплывающего окна")
    @FindBy(xpath = ".//i[contains(@class, 'popup__close')]")
    private WebElement closeWebElement;

    @Name("Предварительный просмотр групп объявлений")
    @FindBy(xpath = ".//div[contains(@class, 'b-group-preview2__banner-item')]")
    private List<BannerGroupPreviewItemBlock> previewItemsBlocks;

    @Name("Кнопка 'Сохранить'")
    @FindBy(xpath = ".//button[contains(@class, 'save')]")
    private Button saveButton;

    @Name("Кнопка 'Отмена'")
    @FindBy(xpath = ".//button[contains(@class, 'cancel')]")
    private Button cancelButton;

    @Name("Элемент переключения на архив")
    @FindBy(xpath = ".//span[contains(@class, 'go-archive')]")
    private WebElement archiveWebElement;

    @Name("Элемент переключения на все объявления")
    @FindBy(xpath = ".//span[contains(@data-bem, '\"action\":\"return\"')]")
    private WebElement allBannersWebElement;

    @Name("Ссылки на переключение страниц")
    @FindBy(xpath = "//a[contains(@class, 'b-pager__page')]")
    public List<Link> pageLinks;

    @Name("Элемент ожидания ответа от сервера (паранжа)")
    @FindBy(xpath = "//div[@class = 'b-banners-group-preview__paranja']")
    private WebElement paranjaWebElement;

    @Name("Ссылка на открытие попапа автокоррекции")
    @FindBy(xpath = ".//div[contains(@class, 'b-banner-errata-informer')]//span[contains(@class, 'link')]")
    private WebElement openInformer;

    @Name("Переключатель вкладки превью")
    @FindBy(xpath = ".//div[contains(@class,'b-banner-preview-filter2')]//input")
    protected RadioBEM previewType;

    public void clickOpenInformer() {
        openInformer.click();
    }

    public BannerGroupPreviewItemBlock getBannerGroupPreviewItem(Long bannerId) {
        BannerGroupPreviewItemBlock block = getBannerGroupPreviewItemOrNullIfEmpty(bannerId);
        if (block != null) {
            return block;
        } else {
            throw new DirectWebError("Не найден баннер " + bannerId);
        }
    }

    public BannerGroupPreviewItemBlock getBannerGroupPreviewItemOrNullIfEmpty(Long bannerId) {
        waitForLoadingComplete();
        return previewItemsBlocks.stream().filter(t -> t.getNumber().contains(bannerId.toString())).findFirst()
                .orElse(null);
    }

    private WebElement getParanjaWebElement() {
        return paranjaWebElement;
    }

    private Link getPageLink(String pageNumber) {
        waitForLoadingComplete();

        return pageLinks.stream().filter(t -> t.getText().equals(pageNumber)).findFirst().orElse(null);
    }

    public Boolean getBannertGroupPreviewItemTumblerStatus(Long bannerId) {
        BannerGroupPreviewItemBlock item = getBannerGroupPreviewItem(bannerId);
        if (item == null) {
            throw new DirectWebError("Не найден попап превью группы для баннера " + bannerId);
        } else {
            return item.getTumblerStatus();
        }
    }

    public void checkBannerParameters(BannerInfoWeb expectedBean) {
        BannerGroupPreviewItemBlock item = getBannerGroupPreviewItem(expectedBean.getBannerId());
        if (item == null) {
            throw new DirectWebError("Не найден попап превью группы для баннера " + expectedBean.getBannerId());
        } else {
            item.checkBannerParameters(expectedBean);
        }
    }

    public void checkMobileAppBannerParameters(MobileAppBannerInfoWeb expectedBean) {
        BannerGroupPreviewItemBlock item = getBannerGroupPreviewItem(expectedBean.getBannerId());
        if (item == null) {
            throw new DirectWebError("Не найден попап превью группы для баннера " + expectedBean.getBannerId());
        } else {
            item.checkMobileAppBannerParameters(expectedBean);
        }
    }

    public void selectTumbler(Long bannerId, Boolean status) {
        BannerGroupPreviewItemBlock item = getBannerGroupPreviewItem(bannerId);
        if (item == null) {
            throw new DirectWebError("Не найден попап превью группы для баннера " + bannerId);
        } else {
            item.selectTumbler(status);
        }
    }

    public void selectPage(String pageNumber) {
        Link pageLink = getPageLink(pageNumber);
        if (pageLink == null) {
            throw new DirectWebError(String.format("Не найдена ссылка на страницу с номером %s", pageNumber));
        } else {
            pageLink.click();
        }
    }

    public void clickRemoveButton(Long bannerId) {
        BannerGroupPreviewItemBlock item = getBannerGroupPreviewItem(bannerId);
        if (item == null) {
            throw new DirectWebError("Не найден попап превью группы для баннера " + bannerId);
        } else {
            item.clickRemoveButton();
        }
    }

    public void clickCloseWebElement() {
        waitForLoadingComplete();
        closeWebElement.click();
    }

    public void clickSaveButton() {
        waitForLoadingComplete();
        saveButton.click();

        // Требуется время на сохранение данных
        waitForLoadingComplete();
    }

    public void clickArchiveWebElement() {
        waitForLoadingComplete();
        archiveWebElement.click();

        // Требуется время на обновление данных
        waitForLoadingComplete();
    }

    public void clickAllBannersWebElement() {
        waitForLoadingComplete();
        allBannersWebElement.click();

        // Требуется время на обновление данных
        waitForLoadingComplete();
    }

    public void clickCancelButton() {
        waitForLoadingComplete();
        cancelButton.click();
    }

    public void clickArchiveItem(Long bannerId) {
        BannerGroupPreviewItemBlock item = getBannerGroupPreviewItem(bannerId);
        item.clickArchiveButton();

        // Требуется время на сохранение данных
        waitForLoadingComplete();
    }

    public void clickUnArchiveItem(Long bannerId) {
        BannerGroupPreviewItemBlock item = getBannerGroupPreviewItem(bannerId);
        if (item == null) {
            throw new DirectWebError("Не найден попап превью группы для баннера " + bannerId);
        } else {
            item.clickUnArchiveButton();
        }
    }

    public void clickPreviewType(BannerPreviewType type) {
        if (previewType == null) {
            return;
        }
        fillRadio(previewType, type.toString(), RadioInputMethod.BY_VALUE);
    }

    public void checkBannerGroupItem(Long bannerId, Matcher<WebElement> matcher) {
        BannerGroupPreviewItemBlock item = getBannerGroupPreviewItemOrNullIfEmpty(bannerId);
        assertThat("баннер не удовлетворяет условию", item, matcher);
    }

    public void waitForLoadingComplete() {
        should(not(IsDisplayedMatcher.isDisplayed())).whileWaitingUntil(timeoutHasExpired()).matches(getParanjaWebElement());
    }

}
