package ru.yandex.autotests.direct.web.pages.showcampbem.blocks.banners;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.HtmlElement;

import static org.hamcrest.MatcherAssert.assertThat;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
public class BannerListTab extends HtmlElement {

    //region Fields
    @Name("Название таба")
    @FindBy(css = "div.b-campaign-tabs__title")
    private WebElement tabTitle;

    @Name("Количество баннеров на вкладке")
    @FindBy(css = "div.b-campaign-tabs__count")
    private WebElement tabCount;
    //endregion

    public void select() {
        tabTitle.click();
    }

    public String getTitle() {
        return tabTitle.getText().trim();
    }

    public String getTabCount() {
        try {
            return tabCount.getText().trim();
        } catch (NumberFormatException e) {
            return "";
        }
    }

    public void checkBannersTabCount(org.hamcrest.Matcher matcher) {
        assertThat(tabCount, matcher);
    }
}
