package ru.yandex.autotests.direct.web.pages.showcampbem.blocks.banners;

import java.util.List;

import org.hamcrest.Matcher;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.data.banners.BannerTabsEnum;
import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.HtmlElement;

import static org.hamcrest.MatcherAssert.assertThat;

@FindBy(xpath = "./*")
public class BannerListTabs extends HtmlElement {

    //region Fields
    @Name("Табы таблички баннеров")
    @FindBy(css = "div.b-campaign-tabs__tab")
    private List<BannerListTab> bannerTabsList;
    //endregion

    private List<BannerListTab> getBannerTabsList() {
        return bannerTabsList;
    }

    public BannerListTab getBannerTab(BannerTabsEnum tab) {
        for (BannerListTab bannerTab : getBannerTabsList()) {
            if (tab.getName().equals(bannerTab.getTitle())) {
                return bannerTab;
            }
        }
        return null;
    }

    public void clickOnBannerTab(BannerTabsEnum tab) {
        BannerListTab bannerTab = getBannerTab(tab);
        if (bannerTab == null) {
            throw new DirectWebError("Таб не найден " + tab.getName());
        } else {
            bannerTab.select();
        }
    }

    public void checkBannersTabCount(BannerTabsEnum tab, Matcher matcher) {
        BannerListTab bannerTab = getBannerTab(tab);
        if (bannerTab == null) {
            throw new DirectWebError("Таб не найден " + tab.getName());
        } else {
            bannerTab.checkBannersTabCount(matcher);
        }
    }

    public void checkBannersTab(BannerTabsEnum tab, Matcher matcher) {
        BannerListTab bannerTab = getBannerTab(tab);
        assertThat("таб " + tab.getName() + " не прошел проверку", bannerTab, matcher);
    }
}
