package ru.yandex.autotests.direct.web.pages.showcampbem.blocks.banners;

import org.junit.Assert;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.objects.banners.BannerInfoWeb;
import ru.yandex.autotests.direct.web.pages.showcampbem.blocks.BannerPreviewContentBlockBase;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Link;

import static ch.lambdaj.Lambda.on;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.direct.web.util.beanutils.BeanFieldsSetter.inAccordanceWith;

/**
 * Created by aleran on 12.10.2015.
 */
public class BannerPreviewContentPopupBlock extends BannerPreviewContentBlockBase {

    @Name("Заголовок баннера")
    @FindBy(css = "div.b-banner-preview2__title a")
    private Link bannerTitle;

    @Name("Текст баннера")
    @FindBy(css = "div.b-banner-preview2__body")
    private WebElement bannerBody;

    @Name("Домен")
    @FindBy(css = "div.b-banner-preview2__domain")
    private WebElement bannerDomain;

    @Name("Статус")
    @FindBy(xpath = ".//div[@class = 'b-banner-status__admin-status']")
    private WebElement statusWebElement;


    public void checkParameters(BannerInfoWeb expectedBean) {
        Assert.assertThat("неверные параметры баннера", getFormFieldsAccording(expectedBean),
                beanEquals(expectedBean));
    }
    //endregion

    public BannerInfoWeb getFormFieldsAccording(BannerInfoWeb expectedBean) {
        BannerInfoWeb actualBean = inAccordanceWith(expectedBean).forNew(BannerInfoWeb.class)
                .set("title", bannerTitle, on(Link.class).getText())
                .set("text", bannerBody, on(WebElement.class).getText())
                .set("domain", bannerDomain, on(WebElement.class).getText())
                .set("statusSitelinksModerate", statusWebElement, on(WebElement.class).getText())
                .getActualBean();
        actualBean.setHref(expectedBean.getHref());
        actualBean.setGeo(expectedBean.getGeo());
        actualBean.setAdGroupID(expectedBean.getAdGroupID());
        actualBean.setBannerId(expectedBean.getBannerId());
        actualBean.setCampaignId(expectedBean.getCampaignId());
        return actualBean;
    }
}
