package ru.yandex.autotests.direct.web.pages.showcampbem.blocks.banners;

import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.data.banners.BannerSearchTypeEnum;
import ru.yandex.autotests.direct.web.webelements.bem.RadioBEM;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.TextInput;

/**
 * Created by shmykov on 26.05.14.
 */

@FindBy(xpath = ".//div[contains(@class, 'b-banners-search')][@data-bem]")
public class BannersSearchBlock extends HtmlElement{

    @Name("Поле для ввода признака поиска объявления")
    @FindBy(xpath = ".//input[contains(@name, 'search_banner')]")
    private TextInput bannerSearchTypeInput;

    @Name("Радио кнопка По номеру объявления")
    @FindBy(xpath = ".//span[contains(@class, 'b-banners-search__search-by')]//input")
    private RadioBEM searchType;

    @Name("Кнопка Искать")
    @FindBy(xpath = ".//button[contains(@class, 'b-banners-search__submit')]")
    private Button searchButton;

    public void fillBannerSearchTypeInput(String inputText) {
        bannerSearchTypeInput.sendKeys(inputText);
    }

    public void chooseBannerSearchType(BannerSearchTypeEnum type) {
        searchType.selectByValue(type.getValue());
    }

    public void clickSearchBannersButton() {
        searchButton.click();
    }
}
