package ru.yandex.autotests.direct.web.pages.showcampbem.blocks.banners;

import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.data.mediaplan.CopyBannerParameters;
import ru.yandex.autotests.direct.web.webelements.bem.CheckBoxBEM;
import ru.yandex.autotests.direct.web.webelements.bem.SelectBEM;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.HtmlElement;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
@Name("Попап параметров копирования баннера в медиаплан")
@FindBy(xpath = "//div[contains(@class, 'b-banners-to-media')][@data-bem]")
public class CopyBannerPopupBlock extends HtmlElement {

    @Name("Есть ключевые фразы состоящие из одного слова")
    @FindBy(xpath = ".//input[@name = 'has_one_word_phrase']")
    private CheckBoxBEM hasOneWordPhrase;

    @Name("Чекбокс есть отключенные фразы")
    @FindBy(css = "input[name=has_floated_off]")
    private CheckBoxBEM hasDeclinedPhrase;

    @Name("Чекбокс есть фразы ни одно слово из которых...")
    @FindBy(css = "input[name=has_absent_phrases]")
    private CheckBoxBEM hasAbsentPhrase;

    @Name("Чекбокс есть фразы с CTR")
    @FindBy(css = "input[name=has_ctr]")
    private CheckBoxBEM hasCTR;

    @Name("Чекбокс есть определенное количество фраз")
    @FindBy(css = "input[name=has_phrases_count]")
    private CheckBoxBEM hasCount;

    @Name("Чекбокс есть фразы с заданным прогнозом показов")
    @FindBy(css = "input[name=has_forecast]")
    private CheckBoxBEM hasForecast;

    @Name("Селект количество фраз")
    @FindBy(css = "select[name=phrases_count_value]")
    private SelectBEM countSelect;

    @Name("Селект CTR")
    @FindBy(css = "select[name=ctr_value]")
    private SelectBEM ctrSelect;

    @Name("Селект прогноз")
    @FindBy(css = "select[name=forecast_value]")
    private SelectBEM forecastSelect;

    @Name("Кнопка скопировать в медиаплан")
    @FindBy(css = ".b-banners-to-media__submit-button")
    private Button copyButton;

    public void fillCopyBannerParameters(CopyBannerParameters copyBannerParameters) {
        fillHasAbsentPhrase(copyBannerParameters.getHasAbsentPhrase());
        fillHasDeclinedPhrase(copyBannerParameters.getHasDeclinedPhrase());
        fillHasOneWordPhrase(copyBannerParameters.getHasOneWordPhrase());
        fillPhrasesCount(copyBannerParameters.getPhrasesCount());
        fillPhrasesCTR(copyBannerParameters.getPhrasesCTR());
        fillPhrasesForecast(copyBannerParameters.getPhrasesForecast());
    }

    private void fillHasOneWordPhrase(Boolean hasOneWordPhrase) {
        if (hasOneWordPhrase != null) {
            this.hasOneWordPhrase.set(hasOneWordPhrase);
        }
    }

    private void fillHasDeclinedPhrase(Boolean hasDeclinedPhrase) {
        if (hasDeclinedPhrase != null) {
            this.hasDeclinedPhrase.set(hasDeclinedPhrase);
        }
    }

    private void fillHasAbsentPhrase(Boolean hasAbsentPhrase) {
        if (hasAbsentPhrase != null) {
            this.hasAbsentPhrase.set(hasAbsentPhrase);
        }
    }

    private void fillPhrasesCTR(Integer phrasesCTR) {
        if (phrasesCTR != null) {
            this.hasCTR.select();
            ctrSelect.selectByValue(Integer.toString(phrasesCTR));
        }
    }

    private void fillPhrasesCount(Integer phrasesCount) {
        if (phrasesCount != null) {
            this.hasCount.select();
            countSelect.selectByValue(Integer.toString(phrasesCount));
        }
    }

    private void fillPhrasesForecast(Integer phrasesForecast) {
        if (phrasesForecast != null) {
            this.hasForecast.select();
            forecastSelect.selectByValue(Integer.toString(phrasesForecast));
        }
    }

    public void clickCopy() {
        copyButton.click();
    }
}