package ru.yandex.autotests.direct.web.pages.showcampbem.blocks.banners;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.cmd.data.commons.banner.HashFlags;
import ru.yandex.autotests.direct.web.objects.banners.GroupMobileInfoWeb;
import ru.yandex.autotests.direct.web.objects.banners.MobileAppBannerInfoWeb;
import ru.yandex.autotests.direct.web.pages.showcampbem.blocks.BannerPreviewContentBlockBase;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Link;

import static ch.lambdaj.Lambda.on;
import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.direct.web.util.beanutils.BeanFieldsSetter.inAccordanceWith;

/**
 * Created by aleran on 12.10.2015.
 */
public class MobileAppBannerPreviewContentPopupBlock extends BannerPreviewContentBlockBase {

    @Name("Заголовок объявления")
    @FindBy(xpath = ".//div[contains(@class, 'b-banner-preview2__mobile-content-title')]//a")
    private Link titleLink;

    @Name("Текст объявления")
    @FindBy(xpath = ".//div[@class = 'b-banner-preview2__mobile-content-body']")
    private WebElement bodyWebElement;

    @Name("Ссылка на сайт")
    @FindBy(xpath = ".//div[@class = 'b-banner-preview2__domain']")
    private WebElement domainWebElement;

    @Name("Статус")
    @FindBy(xpath = ".//div[@class = 'b-banner-status__admin-status']")
    private WebElement statusWebElement;

    public String getTrackingHref() {
        return titleLink.getReference().contains("itunes") || titleLink.getReference().contains("play.google")
                ? null : titleLink.getReference();
    }

    public String getStoreHref() {
        return titleLink.getReference().contains("itunes") || titleLink.getReference().contains("play.google")
                ? titleLink.getReference() : null;
    }

    public HashFlags getHashFlags() {
        HashFlags hashFlags = new HashFlags();
        hashFlags.setAge(getAgeRestriction() + getAgeAddition());
        return hashFlags;
    }

    public void checkParameters(MobileAppBannerInfoWeb expectedBean) {
        assertThat("неверные параметры баннера ", getFormFieldsAccording(expectedBean),
                beanEquals(expectedBean));
    }

    public MobileAppBannerInfoWeb getFormFieldsAccording(MobileAppBannerInfoWeb expectedBean) {
        MobileAppBannerInfoWeb actualBean = inAccordanceWith(expectedBean).forNew(MobileAppBannerInfoWeb.class)
                .set("title", titleLink, on(Link.class).getText())
                .set("trackingHref", this, on(MobileAppBannerPreviewContentPopupBlock.class).getTrackingHref())
                .set("body", bodyWebElement, on(WebElement.class).getText())
                .set("geo", this, on(MobileAppBannerPreviewContentPopupBlock.class).getRegionsIDs(expectedBean.getGeo()))
                .set("hashFlags", this, on(MobileAppBannerPreviewContentPopupBlock.class).getHashFlags())
                .getActualBean();

        actualBean.setGroupMobileInfo(new GroupMobileInfoWeb().withStoreContentHref(getStoreHref()));
        actualBean.setBannerId(expectedBean.getBannerId());
        actualBean.setCampaignID(expectedBean.getCampaignID());

        return actualBean;
    }
}
