package ru.yandex.autotests.direct.web.pages.showcampbem.blocks.banners.phrases;

import org.hamcrest.Matcher;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.autotests.direct.web.util.JavaScriptActions;
import ru.yandex.autotests.direct.web.util.WebElementsActions;
import ru.yandex.autotests.direct.web.webelements.NumericInput;
import ru.yandex.qatools.htmlelements.annotations.Name;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalTo;

public abstract class BannerDisplayCriteriaRowBlockBase extends ExtendedHtmlElement{
    //region Fields
    @Name("Ввод значения цены на поиске")
    @FindBy(css = "div.b-edit-phrase-price input")
    private NumericInput priceInput;

    @Name("Обертка цены на поиске (для подсветки)")
    @FindBy(xpath = ".//span[contains(@class, 'b-edit-phrase-price__price')]")
    private WebElement priceInputSpan;
    //endregion

    public void checkPrice(String price) {
        assertThat("ставка для условия показа не соответствует ожидаемой",
                priceInput.getValue(), equalTo(price));
    }

    public void checkPriceInputErrorHighlight(Matcher matcher) {
        assertThat("подсветка поля ввода цены не соответсвует ожиданиям",
                priceInputSpan.getAttribute("class").contains("input_error_yes"), matcher);
    }

    protected NumericInput getPriceInput() {
        return this.priceInput;
    }

    public void setPrice(Float price) {
        if (price == null)
            return;
        new WebElementsActions(config).setNumericValue(priceInput, price);
        new JavaScriptActions(config).fireBlurEvent(priceInput.getWrappedElement());
    }
}
