package ru.yandex.autotests.direct.web.pages.showcampbem.blocks.banners.phrases;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.data.banners.PhrasePriority;
import ru.yandex.autotests.direct.web.webelements.bem.RadioBEM;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.HtmlElement;

@FindBy(xpath = ".//tr[contains(@class,'b-dynamic-conditions-group__conditions')]")
public class BannerDynamicTargetRowBlockBEM extends BannerDisplayCriteriaRowBlockBase{
    //region Fields
    @Name("Приоритет")
    @FindBy(css = "div.b-edit-phrase-price_control-type_autobudget>span")
    private WebElement priority;

    @Name("Название условия нацеливания")
    @FindBy(xpath = ".//span[@class='b-dynamic-condition-row__condition-wrapper'] | .//div[@class='b-dynamic-condition-row__any-condition']")
    private WebElement dynamicTargetName;

    @Name("Показы фразы")
    @FindBy(css = ".b-group-dynamic-condition__shows")
    private WebElement shows;

    @Name("Клики фразы")
    @FindBy(css = ".b-group-dynamic-condition__clicks")
    private WebElement clicks;

    private PriorityPopup priorityPopup;

    //endregion

    public void clickEditPhrase() {
        dynamicTargetName.click();
    }

    private void selectPriority(String priorityApiText) {
        if (priorityApiText == null)
            return;
        PhrasePriority phrasePriority = PhrasePriority.getPhrasePriorityByValue(priorityApiText);
        if (!priority.getText().equals(phrasePriority.getPriorityText())) {
            this.priority.click();
            getPriorityPopup().selectPriority(phrasePriority.getPriorityValue());
        }
    }

    public String getDynamicTargetName() {
        return this.dynamicTargetName.getText();
    }

    public String getPriorityValue() {
        return PhrasePriority.getPhrasePriority(priority.getText()).getPriorityValue();
    }

    private PriorityPopup getPriorityPopup() {
        return priorityPopup;
    }

    @FindBy(xpath = "//div[contains(@class, 'b-group-phrase-autobudget__content')]")
    public static class PriorityPopup extends HtmlElement {
        @Name("Переключатель приоритета")
        @FindBy(xpath = ".//input[@type = 'radio']")
        private RadioBEM priority;

        private void selectPriority(String value) {
            priority.selectByValue(value);
        }
    }
}
