package ru.yandex.autotests.direct.web.pages.showcampbem.blocks.banners.phrases;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.WrapsElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.utils.matchers.BeanEquals;
import ru.yandex.autotests.direct.web.data.banners.MinusKeyWordsTypes;
import ru.yandex.autotests.direct.web.data.banners.PhrasePriority;
import ru.yandex.autotests.direct.web.data.priceconstructor.BannerPhraseState;
import ru.yandex.autotests.direct.web.data.priceconstructor.TrafficVolume;
import ru.yandex.autotests.direct.web.objects.banners.BannerPhraseInfoWeb;
import ru.yandex.autotests.direct.web.objects.retargeting.RetargetingConditionWeb;
import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.autotests.direct.web.pages.showcampbem.blocks.banners.phrases.prices.PricesBlock;
import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.autotests.direct.web.util.JavaScriptActions;
import ru.yandex.autotests.direct.web.util.WebElementsActions;
import ru.yandex.autotests.direct.web.util.testinterfaces.IWebFrom;
import ru.yandex.autotests.direct.web.webelements.NumericInput;
import ru.yandex.autotests.direct.web.webelements.bem.RadioBEM;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.HtmlElement;

import static ch.lambdaj.Lambda.on;
import static java.lang.Long.parseLong;
import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.direct.web.util.OperationSystemUtils.sleep;
import static ru.yandex.autotests.direct.web.util.beanutils.BeanFieldsSetter.inAccordanceWith;
import static ru.yandex.autotests.direct.web.util.converters.Banners.toBannerInfo;
import static ru.yandex.qatools.htmlelements.matchers.WrapsElementMatchers.exists;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
public class BannerPhraseRowBlockBEM extends ExtendedHtmlElement implements IWebFrom<BannerPhraseInfoWeb> {

    public final static String NEW_AD_GROUP_ID = "new";
    public final static String FIRST_NEW_AD_GROUP_ID = "new1";

    //region Fields
    @Name("Ввод значения цены на поиске")
    @FindBy(css = "div.b-edit-phrase-price input")
    private NumericInput priceInput;

    @Name("Обертка цены на поиске (для подсветки)")
    @FindBy(xpath = ".//span[contains(@class, 'b-edit-phrase-price__price')]")
    private WebElement priceInputSpan;

    @Name("Текст фразы")
    @FindBy(xpath =
            ".//*[contains(@class, 'b-phrase-key-words')] | .//div[contains(@class, 'b-phrase_type_retargeting')"
                    + " or contains(@class, 'b-phrase_type_relevance-match')]//*[contains(@class, 'b-phrase__content')]")
    private WebElement phraseText;

    @Name("Кнопка открытия параметров фразы")
    @FindBy(xpath = ".//img[contains(@class, 'b-phrase__minus-words-expander')]")
    private WebElement openMinusWords;

    @Name("Показы фразы")
    @FindBy(css = ".b-group-phrase__shows")
    private WebElement shows;

    @Name("Клики фразы")
    @FindBy(css = ".b-group-phrase__clicks")
    private WebElement clicks;

    @Name("Цена входа в гарантию")
    @FindBy(css = ".b-group-phrase__min .b-group-phrase__price-value")
    private WebElement priceGuaranty;

    @Name("Цена первого места в гарантии")
    @FindBy(css = ".b-group-phrase__max .b-group-phrase__price-value")
    private WebElement priceGuarantyFirst;

    @Name("Цена спецразмещения")
    @FindBy(css = ".b-group-phrase__pmin .b-group-phrase__price-value")
    private WebElement priceSpecialPlace;

    @Name("Цена первого места в спецразмещении")
    @FindBy(css = ".b-group-phrase__pmax .b-group-phrase__price-value")
    private WebElement priceSpecialPlaceFirst;

    @Name("Цена второго места в спецразмещении")
    @FindBy(css = ".b-group-phrase__pmax2 .b-group-phrase__price-value")
    private WebElement priceSpecialPlaceSecond;

    @Name("Цена входа в гарантию")
    @FindBy(css = ".b-group-phrase__min .b-group-phrase__price-value_type_amnesty")
    private WebElement priceGuarantyAmnesty;

    @Name("Цена первого места в гарантии")
    @FindBy(css = ".b-group-phrase__max .b-group-phrase__price-value_type_amnesty")
    private WebElement priceGuarantyFirstAmnesty;

    @Name("Цена спецразмещения")
    @FindBy(css = ".b-group-phrase__pmin .b-group-phrase__price-value_type_amnesty")
    private WebElement priceSpecialPlaceAmnesty;

    @Name("Цена первого места в спецразмещении")
    @FindBy(css = ".b-group-phrase__pmax .b-group-phrase__price-value_type_amnesty")
    private WebElement priceSpecialPlaceFirstAmnesty;

    @Name("Цена второго места в спецразмещении")
    @FindBy(css = ".b-group-phrase__pmax2 .b-group-phrase__price-value_type_amnesty")
    private WebElement priceSpecialPlaceSecondAmnesty;

    @Name("Цена клика на поиске")
    @FindBy(css = "span.b-group-phrase__search-price")
    private WebElement priceOnSearch;

    @Name("Приоритет")
    @FindBy(css = "div.b-edit-phrase-price_control-type_autobudget>span")
    private WebElement priority;

    @Name("Кнопка восстановить")
    @FindBy(css = "button.b-group-phrase__restore")
    private Button restoreButton;

    @Name("Родительская таблица")
    @FindBy(xpath = "./ancestor::tbody[contains(@class, 'b-phrases-list-group')]")
    private WebElement parentTable;

    @Name("Название условия ретаргетинга")
    @FindBy(xpath = ".//span[contains(@class, 'b-phrase__content')]")
    private WebElement retargetingName;

    @Name("Прогноз траффика")
    @FindBy(xpath = ".//div[contains(@class, 'b-group-phrase__current-traffic-volume')]")
    private WebElement trafficVolumeForecast;

    @Name("Блок цен на поиске")
    private PricesBlock pricesBlock;

    private PriorityPopup priorityPopup;
    private MinusWordsPopup minusWordsPopup;
    private ParametersPopup parametersPopup;
    //endregion

    //region Field getters
    private PriorityPopup getPriorityPopup() {
        return priorityPopup;
    }

    private MinusWordsPopup getMinusWordsPopup() {
        return minusWordsPopup;
    }

    private ParametersPopup getParametersPopup() {
        return parametersPopup;
    }

    //endregion

    //region Actions
    public void openMinusWordsPopup() {
        new JavaScriptActions(config).scrollToElement(openMinusWords);
        openMinusWords.click();
    }

    public void closeMinusWordsPopup() {
        getMinusWordsPopup().close();
    }

    public void clickEditPhrase() {
        new JavaScriptActions(config).scrollToElement(phraseText);
        phraseText.click();
    }

    public void fillPhraseText(String text) {
        if (text == null) {
            return;
        }
        clickEditPhrase();
        getParametersPopup().setPhraseText(text);
    }

    public void restore() {
        restoreButton.click();
    }

    public void switchOn() {
        clickEditPhrase();
        getParametersPopup().setTumblerSelected(true);
        getParametersPopup().clickOk();
    }

    public void switchOff() {
        clickEditPhrase();
        getParametersPopup().setTumblerSelected(false);
        getParametersPopup().clickOk();
    }

    public Boolean isPhraseActive() {
        clickEditPhrase();
        return getParametersPopup().isPhraseActive();
    }

    public void deleteCondition() {
        clickEditPhrase();
        getParametersPopup().clickDelete();
    }

    public void clickRefinePhrase() {
        clickEditPhrase();
        getParametersPopup().clickrefineButton();
    }

    public void openHiddenAndDeclined() {
        if (getParentTableClass().contains("hide-inactive_yes")) {
            parentTable.findElement(By.xpath(".//div[contains(@class, 'inactive-toggler_mode_show')]")).click();
        }
    }
    //endregion

    //region Assertions
    public void checkMinusWords(org.hamcrest.Matcher matcher, MinusKeyWordsTypes keyWordsType) {
        String wordsContent = "";
        if (exists().matches(openMinusWords) && openMinusWords.isDisplayed()) {
            openMinusWordsPopup();
            switch (keyWordsType) {
                case ADDED:
                    wordsContent = getMinusWordsPopup().getAddedMinusWordsText();
                    break;
                case AUTO_ADDED:
                    wordsContent = getMinusWordsPopup().getAutoAddedMinusWordsText();
                    break;
                case BANNER:
                    wordsContent = getMinusWordsPopup().getBannerMinusWordsText();
                    break;
                case CAMPAIGN:
                    wordsContent = getMinusWordsPopup().getCampaignMinusWordsText();
                    break;
            }
            closeMinusWordsPopup();
        }
        List<String> actualWords = Arrays.asList(wordsContent.replaceFirst("-", "").replace(" ", "").split("-"));
        if (wordsContent == null || wordsContent.equals("")) {
            actualWords = new ArrayList();
        }
        assertThat("неверные минус слова", actualWords, matcher);
    }


    public void checkPrice(BannerPhraseInfoWeb expectedBean, org.hamcrest.Matcher<WrapsElement> matcher) {
        if (!isDisplayed()) {
            openHiddenAndDeclined();
        }
        assertThat("поле ввода цены для фразы " + expectedBean.getPhrase() + " не прошло проверку",
                priceInput, matcher);
    }

    public void checkPhraseMinusKeyWordPopupText(org.hamcrest.Matcher matcher) {
        getMinusWordsPopup().click();
        takeScreenshot();
        assertThat("текст в попапе минус слов не соответствует ожиданиям",
                getMinusWordsPopup().getText(), matcher);
        getMinusWordsPopup().close();
    }

    public void checkPriceInputErrorHighlight(org.hamcrest.Matcher<Boolean> matcher) {
        assertThat("подсветка поля ввода цены не соответсвует ожиданиям",
                priceInputSpan.getAttribute("class").contains("input_error_yes"), matcher);
    }

    //endregion

    //region IWebForm
    @Override
    public void fillParameters(BannerPhraseInfoWeb bean) {
        if (!priceIsOnlyForOnePlatform(bean)) {
            throw new DirectWebError("Одновременно можно установить цену только на одной площадке");
        }
        fillPrice(bean.getPrice());
        fillPrice(bean.getContextPrice());
        selectPriority(bean.getAutoBudgetPriority());
        setPhraseActive(bean.getActive());
    }

    public void fillParameters(RetargetingConditionWeb bean) {
        fillParameters(toBannerInfo(bean));
    }

    public void setPhraseActive(Boolean isActive) {
        if (isActive == null) {
            return;
        }
        if (isActive) {
            switchOn();
        } else {
            switchOff();
        }
    }

    public void checkParameters(BeanEquals<BannerPhraseInfoWeb> matcher) {
        assertThat("параметры фразы соответствуют ожидаемым", getFormFieldsAccording(matcher.getExpectedBean()),
                matcher);
    }

    @Override
    public void checkParameters(BannerPhraseInfoWeb expectedBean) {
        checkParameters(beanEquals(expectedBean));
    }

    @Override
    public BannerPhraseInfoWeb getFormFieldsAccording(BannerPhraseInfoWeb expectedBean) {
        if (!priceIsOnlyForOnePlatform(expectedBean)) {
            throw new DirectWebError("Одновременно можно проверить цену только на одной площадке");
        }

        if (isDeclined() || isLowCTR()) {
            openHiddenAndDeclined();
        }

        BannerPhraseInfoWeb result = new BannerPhraseInfoWeb();
        result.setPhrase(expectedBean.getPhrase());
        result.setBannerId(expectedBean.getBannerId());
        result.setAdGroupID(expectedBean.getAdGroupID());


        if (WebElementsActions.isDisplayed(pricesBlock)) {
            return inAccordanceWith(expectedBean).forExisting(result)
                    .set("price", priceInput, on(NumericInput.class).getValue())
                    .set("contextPrice", priceInput, on(NumericInput.class).getValue())
                    .set("autoBudgetPriority", this, on(BannerPhraseRowBlockBEM.class).getPriorityValue())
                    .set("currentOnSearch", priceOnSearch, on(WebElement.class).getText())
                    .set("state", this, on(BannerPhraseRowBlockBEM.class).getState())
                    .set("active", this, on(BannerPhraseRowBlockBEM.class).isPhraseActive())
                    .set("shows", shows, on(WebElement.class).getText())
                    .set("clicks", clicks, on(WebElement.class).getText())
                    .set("trafficVolumeForecast", trafficVolumeForecast, on(WebElement.class).getText())
                    .getActualBean();
        } else {
            return inAccordanceWith(expectedBean).forExisting(result)
                    .set("price", priceInput, on(NumericInput.class).getValue())
                    .set("contextPrice", priceInput, on(NumericInput.class).getValue())
                    .set("autoBudgetPriority", this, on(BannerPhraseRowBlockBEM.class).getPriorityValue())
                    .set("currentOnSearch", priceOnSearch, on(WebElement.class).getText())
                    .set("state", this, on(BannerPhraseRowBlockBEM.class).getState())
                    .set("active", this, on(BannerPhraseRowBlockBEM.class).isPhraseActive())
                    .set("shows", shows, on(WebElement.class).getText())
                    .set("clicks", clicks, on(WebElement.class).getText())
                    .getActualBean();
        }
    }

    public RetargetingConditionWeb getRetargetingCondition(RetargetingConditionWeb expectedBean) {
        if (!priceIsOnlyForOnePlatform(expectedBean)) {
            throw new DirectWebError("Одновременно можно проверить цену только на одной площадке");
        }

        RetargetingConditionWeb result = new RetargetingConditionWeb();
        result.setRetargetingConditionName(expectedBean.getRetargetingConditionName());
        result.setBannerId(expectedBean.getBannerId());
        result.setAdGroupId(expectedBean.getAdGroupId());

        return inAccordanceWith(expectedBean).forExisting(result)
                .set("contextPrice", priceInput, on(NumericInput.class).getValue())
                .set("autoBudgetPriority", this, on(BannerPhraseRowBlockBEM.class).getPriorityValue())
                .getActualBean();
    }
    //endregion

    private String getParentTableClass() {
        return parentTable.getAttribute("class");
    }

    private void selectPriority(String priorityApiText) {
        if (priorityApiText == null) {
            return;
        }
        PhrasePriority phrasePriority = PhrasePriority.getPhrasePriorityByValue(priorityApiText);
        if (!priority.getText().equals(phrasePriority.getPriorityText())) {
            this.priority.click();
            getPriorityPopup().selectPriority(phrasePriority.getPriorityValue());
        }
    }

    public void fillPrice(Float price) {
        if (price == null) {
            return;
        }
        new WebElementsActions(config).setNumericValue(priceInput, price);
        new JavaScriptActions(config).fireBlurEvent(priceInput.getWrappedElement());
        sleep(500);
    }

    public Float getPrice() {
        return Float.parseFloat(priceInput.getValue());
    }

    private boolean priceIsOnlyForOnePlatform(RetargetingConditionWeb condition) {
        int level = 0;
        level += condition.getContextPrice() == null ? 0 : 1;
        level += condition.getAutoBudgetPriority() == null ? 0 : 1;
        return !(level > 1);
    }

    private boolean priceIsOnlyForOnePlatform(BannerPhraseInfoWeb phrase) {
        int level = 0;
        level += phrase.getPrice() == null ? 0 : 1;
        level += phrase.getContextPrice() == null ? 0 : 1;
        level += phrase.getAutoBudgetPriority() == null ? 0 : 1;
        return !(level > 1);
    }

    public String getPhraseID() {
        Pattern pattern = Pattern.compile("modelId\":\"\\d+");
        Matcher matcher = pattern.matcher(this.getAttribute("data-bem"));
        if (matcher.find()) {
            return matcher.group().replace("modelId\":\"", "");
        } else {
            return null;
        }
    }

    /**
     * @return Текст фразы
     */
    public String getPhraseText() {
        return this.phraseText.getText().replace("+", "").trim();
    }

    /**
     * имеет вид Условие: "Retargeting" (ретаргетинг)
     *
     * @return текст условия ретаргетинга
     */
    public String getRetargetingName() {
        String result = retargetingName.getText();
        if (result != null) {
            //вырезаем всё лишнее
            int lastIndexOfCommas = result.lastIndexOf("\"");
            return lastIndexOfCommas < 0 ? result.trim() : result.trim().substring(1, lastIndexOfCommas);
        }
        return result;
    }

    public String getPriorityValue() {
        return PhrasePriority.getPhrasePriority(priority.getText()).getPriorityValue();
    }

    public String getState() {
        if (isDeclined()) {
            return BannerPhraseState.DECLINED.toString();
        } else if (isLowCTR()) {
            return BannerPhraseState.LOW_CTR.toString();
        } else if (isSwitchedOffOnSearch()) {
            return BannerPhraseState.SWITCHED_OFF_ON_SEARCH.toString();
        } else if (isActive()) {
            return BannerPhraseState.ACTIVE.toString();
        }
        return null;
    }

    public Long getAdGroupID() {
        String result;
        Pattern pattern = Pattern.compile("\"parentId\":[A-Za-z0-9\"]+");
        Matcher matcher = pattern.matcher(this.getAttribute("data-bem"));
        if (matcher.find()) {
            result = matcher.group().replace("\"parentId\":", "").replace("\"", "");
        } else {
            return null;
        }
        //для совместимости с бинами (в них хранится 0 в поле adGroupID для нового баннера)
        if (NEW_AD_GROUP_ID.equals(result) || FIRST_NEW_AD_GROUP_ID.equals(result)) {
            result = "0";
        }
        return parseLong(result);
    }

    public Boolean isDeclined() {
        return getParentTableClass().contains("state_declined");
    }

    public Boolean isLowCTR() {
        return getParentTableClass().contains("low-ctr");
    }

    public Boolean isSwitchedOffOnSearch() {
        return getParentTableClass().contains("state_context");
    }

    public Boolean isActive() {
        return getParentTableClass().contains("state_active");
    }

    @FindBy(xpath = "//div[contains(@class, 'b-group-phrase-autobudget__content')]")
    public static class PriorityPopup extends HtmlElement {
        @Name("Переключатель приоритета")
        @FindBy(xpath = ".//input[@type = 'radio']")
        private RadioBEM priority;

        private void selectPriority(String value) {
            priority.selectByValue(value);
        }
    }

}