package ru.yandex.autotests.direct.web.pages.showcampbem.blocks.banners.phrases;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.qatools.htmlelements.annotations.Name;

@FindBy(xpath = ".//td[contains(@class,'b-group-feed-filter__cell_contents_yes')]/parent::tr")
public class BannerSmartFilterRowBlockBEM extends BannerDisplayCriteriaRowBlockBase{
    //region Fields

    @Name("Название фильтра")
    @FindBy(xpath = ".//div[contains(@class,'b-feed-filter__name-wrap')]")
    private WebElement filterName;

    @Name("Клики фразы")
    @FindBy(xpath = ".//td[contains(@class,'b-group-feed-filter__cell_stat_clicks')]")
    private WebElement clicks;

    @Name("Назначить цену на фильтре")
    @FindBy(css = ".b-group-feed-filter__set-price-caption")
    private WebElement setPriceCaption;

    @Name("Сбросить цену на фильтре")
    @FindBy(css = ".b-group-feed-filter__reset-price-caption")
    private WebElement resetPriceCaption;

    //endregion

    public void clickEditPhrase() {
        filterName.click();
    }

    public String getSmartFilterName() {
        return this.filterName.getText();
    }

    @Override
    public void setPrice(Float price) {
        if (!getPriceInput().isDisplayed()) {
            setPriceCaption.click();
        }
        super.setPrice(price);
    }
}
