package ru.yandex.autotests.direct.web.pages.showcampbem.blocks.banners.phrases;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.HtmlElement;

/**
* Created by shmykov on 21.07.14.
*/
@Name("Всплывающее окно минус слов")
@FindBy(xpath = "//div[contains(@class, 'popup_visibility_visible')]")
public class MinusWordsPopup extends HtmlElement {

    @Name("Добавленные минус слова")
    @FindBy(css = "span.b-phrase-minus-words-popup__phrase_type_minus")
    private WebElement addedMinusWords;

    @Name("Добавленные минус слова")
    @FindBy(css = "span.b-phrase-minus-words-popup__phrase_type_auto-minus")
    private WebElement autoAddedMinusWords;

    @Name("Единые минус-слова для всех фраз объявления")
    @FindBy(css = "div.b-phrase-minus-words-popup__banner-minus-words")
    private WebElement bannerMinusWords;

    @Name("Единый набор минус-слов для всех фраз кампании")
    @FindBy(css = "div.b-phrase-minus-words-popup__campaign-minus-words")
    private WebElement campaignMinusWords;

    @Name("Единый набор минус-слов для всех фраз кампании")
    @FindBy(css = ".popup__close")
    private Button popupClose;

    public void close() {
        popupClose.click();
    }

    public String getAddedMinusWordsText() {
        return addedMinusWords.getText();
    }

    public String getAutoAddedMinusWordsText() {
        return autoAddedMinusWords.getText();
    }

    public String getBannerMinusWordsText() {
        return bannerMinusWords.getText();
    }

    public String getCampaignMinusWordsText() {
        return campaignMinusWords.getText();
    }
}
