package ru.yandex.autotests.direct.web.pages.showcampbem.blocks.banners.phrases;

import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.webelements.bem.TumblerBEM;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.TextInput;

import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillTextInput;

/**
* Created by shmykov on 21.07.14.
*/
@Name("Попап редактирования фразы")
@FindBy(xpath = "//div[contains(@class, 'b-phrase-popup__content')]")
public class ParametersPopup extends HtmlElement {

    @Name("Блок редактирования фразы")
    @FindBy(xpath = ".//textarea")
    private TextInput editPhrase;

    @Name("Переключатель состояния фразы")
    @FindBy(xpath = ".//span[contains(@class, 'b-phrase-popup__tumbler')]//input")
    private TumblerBEM phraseTumbler;

    @Name("ОК")
    @FindBy(css = "button.b-phrase-popup__ok-button")
    private Button okButton;

    @Name("Отмена")
    @FindBy(css = "button.b-phrase-popup__cancel-button")
    private Button cancelButton;

    @Name("Удалить")
    @FindBy(css = "button.b-phrase-popup__delete-button")
    private Button deleteButton;

    @Name("Уточнить")
    @FindBy(css = "button.b-phrase-popup__adjust-button")
    private Button refineButton;

    public boolean isPhraseActive() {
        return phraseTumbler.isSelected();
    }

    public void setPhraseText(String text) {
        fillTextInput(editPhrase, text);
        okButton.click();
    }

    public void clickOk() {
        okButton.click();
    }

    public void setTumblerSelected(boolean setSelected) {
        if (setSelected)
            phraseTumbler.select();
        else
            phraseTumbler.deselect();
    }

    public void clickDelete() {
        deleteButton.click();
    }

    public void clickrefineButton() {
        refineButton.click();
    }
}
