package ru.yandex.autotests.direct.web.pages.showcampbem.blocks.banners.phrases.prices;

import java.util.List;
import java.util.stream.Stream;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.data.priceconstructor.TrafficVolume;
import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.autotests.direct.web.util.DirectWebError;

import static com.google.common.base.Strings.isNullOrEmpty;
import static java.util.Objects.isNull;

@FindBy(xpath = ".//div[contains(@class, 'b-group-phrase__price-stat-table b-group-phrase__price-stat-table_is-context_no')]")
public class PricesBlock extends ExtendedHtmlElement {
    private List<TrafficVolumePriceBlock> pricesList;

    private TrafficVolumePriceBlock getPricesBlockForTrafficVolume(TrafficVolume... trafficVolumes) {
        for (TrafficVolume volume : trafficVolumes) {
            TrafficVolumePriceBlock block = pricesList.stream()
                    .filter(x -> x.getTrafficVolume().equals(volume.getVolume()))
                    .findFirst().orElse(null);
            if (!isNull(block)) {
                return block;
            }
        }
        throw new DirectWebError("Не найден блок с ценами для указанных объемов траффика");
    }

    public WebElement getBidPriceByTrafficVolume(TrafficVolume... trafficVolumes) {
        return getPricesBlockForTrafficVolume(trafficVolumes).getBidValue();
    }

    public WebElement getAmnestyPriceByTrafficVolume(TrafficVolume... trafficVolumes) {
        return getPricesBlockForTrafficVolume(trafficVolumes).getAmnestyValue();
    }
}
