package ru.yandex.autotests.direct.web.pages.showcampbem.blocks.banners.phrases.prices;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.qatools.htmlelements.annotations.Name;

@FindBy(xpath = ".//div[contains(@class, 'b-group-phrase__info')]")
public class TrafficVolumePriceBlock extends ExtendedHtmlElement {

    @Name("Объем трафика")
    @FindBy(xpath = ".//div[contains(@class, 'b-group-phrase__price-label')]")
    private WebElement trafficVolume;

    @Name("Прогноз ставки")
    @FindBy(xpath = ".//div[contains(@class, 'b-group-phrase__price-value_type_bid')]")
    private WebElement bidValue;

    @Name("Списанная цена")
    @FindBy(xpath = ".//div[contains(@class, 'b-group-phrase__price-value_type_amnesty')]")
    private WebElement amnestyValue;

    public String getTrafficVolume() {
        String volume = trafficVolume.getText();
        return volume;
    }

    public WebElement getBidValue() {
        return bidValue;
    }

    public WebElement getAmnestyValue() {
        return amnestyValue;
    }
}
