package ru.yandex.autotests.direct.web.pages.showcampbem.blocks.strategy;

import java.util.NoSuchElementException;
import java.util.stream.Stream;

import ru.yandex.autotests.direct.web.util.DirectWebError;

import static com.google.common.base.Strings.isNullOrEmpty;

public class StrategiesEnum {

    public enum Strategies {
        OPTIMIZE_CONVERSIONS("Оптимизация конверсий"),
        OPTIMIZE_ROI("Оптимизация рентабельности"),
        OPTIMIZE_CLICKS("Оптимизация кликов"),
        MANUAL_BID_MANAGEMENT("Ручное управление ставками с оптимизацией");

        Strategies(String value) {
            this.value = value;
        }

        private final String value;

        public String getValue() {
            return value;
        }

        public static Strategies getByTextValue(String value) {
            return Stream.of(values())
                    .filter(x -> x.getValue().equals(value))
                    .findFirst()
                    .orElseThrow(NoSuchElementException::new);
        }
    }

    public enum StrategyShowsType {
        ALL("0"),
        SEARCH("1"),
        NET("2");

        StrategyShowsType(String radioKey) {
            this.radioKey = radioKey;
        }

        private final String radioKey;

        public String getRadioKey() {
            return radioKey;
        }

        public static StrategyShowsType getStrategyShowTypeByValue(String value) {
            return Stream.of(values())
                    .filter(t -> t.getRadioKey().equals(value))
                    .findFirst()
                    .orElseThrow(() -> new DirectWebError("Не найдено значение " + value));
        }
    }

    public enum Restriction {
        AVG_CLICK_PRICE("средней цене клика"),
        WEEK_BUDGET("недельному бюджету"),
        CLICKS("пакету кликов");

        Restriction(String radioKey) {
            this.radioKey = radioKey;
        }

        private final String radioKey;

        public String getRadioKey() {
            return radioKey;
        }

        public static Restriction getRestrictionByValue(String value) {
            if (isNullOrEmpty(value)) {
                return null;
            } else {
                return Stream.of(values())
                        .filter(t -> t.getRadioKey().equals(value))
                        .findFirst()
                        .orElseThrow(() -> new DirectWebError("Не найдено значение " + value));
            }
        }
    }

    public enum ClicksBidType {
        MAX("максимальная"),
        WEEK_AVG("средняя за неделю");

        ClicksBidType(String value) {
            this.value = value;
        }

        private final String value;

        public String getValue() {
            return value;
        }

        public static ClicksBidType getClicksBidTypeByValue(String value) {
            if (isNullOrEmpty(value)) {
                return null;
            } else {
                return Stream.of(values())
                        .filter(t -> t.getValue().equals(value))
                        .findFirst()
                        .orElseThrow(() -> new DirectWebError("Не найдено значение " + value));
            }
        }
    }

    public enum DayBudgetType {
        DISTRIBUTED("распределённый"),
        STANDART("стандартный");

        DayBudgetType(String value) {
            this.value = value;
        }

        private final String value;

        public String getValue() {
            return value;
        }

        public static DayBudgetType getDayBudgetTypeByValue(String value) {
            if (isNullOrEmpty(value)) {
                return null;
            } else {
                return Stream.of(values())
                        .filter(t -> t.getValue().equals(value))
                        .findFirst()
                        .orElseThrow(() -> new DirectWebError("Не найдено значение " + value));
            }
        }
    }

    public enum ContextLimitValue {
        PERCENT_100("100%"),
        PERCENT_50("50%"),
        PERCENT_20("20%");

        ContextLimitValue(String value) {
            this.value = value;
        }

        private final String value;

        public String getValue() {
            return value;
        }

        public static ContextLimitValue getContextLimitValue(String value) {
            if (isNullOrEmpty(value)) {
                return null;
            } else {
                return Stream.of(values())
                        .filter(t -> t.getValue().equals(value))
                        .findFirst()
                        .orElseThrow(() -> new DirectWebError("Не найдено значение " + value));
            }
        }
    }

    public enum AtributionModel {
        LAST_YANDEX_DIRECT_CLICK("Последний переход из Яндекс.Директа"),
        LAST_SIGNIFICANT_CLICK("Последний значимый переход"),
        LAST_CLICK("Последний переход"),
        FIRST_CLICK("Первый переход");

        AtributionModel(String value) {
            this.value = value;
        }

        private final String value;

        public String getValue() {
            return value;
        }

        public static AtributionModel getAtributionModelValue(String value) {
            if (isNullOrEmpty(value)) {
                return null;
            } else {
                return Stream.of(values())
                        .filter(t -> t.getValue().equals(value))
                        .findFirst()
                        .orElseThrow(() -> new DirectWebError("Не найдено значение " + value));
            }
        }
    }
}