package ru.yandex.autotests.direct.web.pages.showcampbem.blocks.strategy;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

import org.hamcrest.Matcher;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.direct.utils.strategy.data.StrategyType;
import ru.yandex.autotests.direct.utils.strategy.objects.CampaignStrategyInfoWeb;
import ru.yandex.autotests.direct.utils.strategy.objects.StrategyClickPriceType;
import ru.yandex.autotests.direct.utils.strategy.objects.StrategyInfoWeb;
import ru.yandex.autotests.direct.web.data.strategy.StrategyShowType;
import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.autotests.direct.web.pages.campaigns.strategy.DayBudgetBemBlock;
import ru.yandex.autotests.direct.web.pages.campaigns.strategy.IStrategyBlock;
import ru.yandex.autotests.direct.web.pages.showcampbem.blocks.NewStrategyChooseBlock;
import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.autotests.direct.web.util.WebDriverUtils;
import ru.yandex.autotests.direct.web.util.matchers.IsDisplayedMatcher;
import ru.yandex.autotests.direct.web.webelements.bem.CheckBoxBEM;
import ru.yandex.autotests.direct.web.webelements.bem.RadioBEM;
import ru.yandex.autotests.direct.web.webelements.bem.SelectBEM;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.TextInput;

import static org.junit.Assert.assertThat;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.direct.utils.strategy.data.StrategyType.CPM_MANUAL_CONTROL;
import static ru.yandex.autotests.direct.utils.strategy.data.StrategyType.MANUAL_CONTROL;
import static ru.yandex.autotests.direct.utils.strategy.data.StrategyType.SHOWS_DISABLED;
import static ru.yandex.autotests.direct.utils.strategy.data.StrategyType.WEEKLY_PACKET_OF_CLICKS;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.getVisibleElement;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.getVisibleElements;
import static ru.yandex.autotests.direct.web.util.beanutils.BeanHelper.copyProperties;
import static ru.yandex.autotests.irt.testutils.beans.BeanFieldsSetter.inAccordanceWith;
import static ru.yandex.qatools.htmlelements.matchers.MatcherDecorators.should;
import static ru.yandex.qatools.htmlelements.matchers.MatcherDecorators.timeoutHasExpired;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
@FindBy(xpath = "//div[contains(@class, 'popup__content')]//div[contains(@class, 'b-campaign-strategy')]")
public class StrategyBemBlock extends ExtendedHtmlElement implements IStrategyBlock {

    @Name("Поле для ввода недельного бюджета")
    @FindBy(xpath = ".//span[contains(@data-bem, '\"name\":\"weekBid\"')]//input")
    private List<TextInput> sumInputList;

    @Name("Поле для ввода средней цены конверсии")
    @FindBy(xpath = ".//span[contains(@data-bem, '\"name\":\"cpa\"')]//input")
    private List<TextInput> avgCpaInputList;

    @Name("Поле для ввода 'Удерживать цену установки'")
    @FindBy(xpath = ".//span[contains(@data-bem, '\"name\":\"cpi\"')]//input")
    private List<TextInput> avgCpiInputList;

    @Name("Поле для ввода коэффициента рентабельности инвестиций")
    @FindBy(xpath = ".//span[contains(@data-bem, '\"name\":\"roi\"')]//input")
    private List<TextInput> roiCoefInputList;

    @Name("Поле для ввода цены за клик средняя/максимальныя")
    @FindBy(xpath = ".//span[contains(@data-bem, '\"name\":\"clickBid\"') or " +
            "contains(@data-bem,'\"name\":\"maxClickBid\"') or " +
            "contains(@data-bem,'\"name\":\"avgClickBid\"')]//input")
    private List<TextInput> clickPriceInputList;

    @Name("Поле для ввода лимита количества кликов")
    @FindBy(xpath = ".//span[contains(@data-bem, '\"name\":\"clicksLimit\"')]//input")
    private List<TextInput> limitClicksInputList;

    @Name("Селект выбора типа цены клика")
    @FindBy(xpath = ".//span[contains(@data-bem, '\"name\":\"clickBidType\"')]//select")
    private List<SelectBEM> typeOfPriceSelectList;

    @Name("Селект выбора цели")
    @FindBy(xpath = ".//span[contains(@data-bem, '\"name\":\"goalId\"')]//select")
    private List<SelectBEM> strategyGoalSelect;

    private DayBudgetBemBlock dayBudgetBemBlock;

    @Name("Кнопка сохранить")
    @FindBy(xpath = ".//button[contains(@class,'choose__save')]")
    private Button saveButton;

    @Name("Кнопка отмена")
    @FindBy(xpath = ".//button[contains(@class,'choose__cancel')]")
    private Button cancelButton;

    @Name("Поле для выбора На всю кампанию/На каждый фильтр")
    @FindBy(xpath = ".//span[contains(@data-bem, '\"name\":\"target\"')]//input")
    private List<RadioBEM> targetRadioList;

    @Name("Поле для ввода CPC на кампанию")
    @FindBy(xpath = ".//span[contains(@data-bem, '\"name\":\"cpcPerCamp\"')]//input")
    private List<TextInput> cpcPerCampInputList;

    @Name("Поле для ввода CPC на фильтр")
    @FindBy(xpath = ".//span[contains(@data-bem, '\"name\":\"cpcPerFilter\"')]//input")
    private List<TextInput> cpcPerFilterInputList;

    @Name("Поле для ввода CPA на кампанию")
    @FindBy(xpath = ".//span[contains(@data-bem, '\"name\":\"cpaPerCamp\"')]//input")
    private List<TextInput> cpaPerCampInputList;

    @Name("Поле для ввода CPA на кампанию")
    @FindBy(xpath = ".//span[contains(@data-bem, '\"name\":\"cpaPerFilter\"')]//input")
    private List<TextInput> cpaPerFilterInputList;

    @Name("Поле для ввода недельного бюджета")
    @FindBy(xpath = ".//span[contains(@data-bem, '\"name\":\"weekBid\"')]//input")
    private List<TextInput> weekBidInputList;

    @Name("Поле для ввода максимальной ставки")
    @FindBy(xpath = ".//span[contains(@data-bem, '\"name\":\"maxClickBid\"')]//input")
    private List<TextInput> maxClickBidInputList;

    @Name("Поле для рентабельности инвестиций")
    @FindBy(xpath = ".//span[contains(@data-bem, '\"name\":\"roi\"')]//input")
    private List<TextInput> roiInputList;

    @Name("Селект выбора процента возвращаемого в рекламу дохода")
    @FindBy(xpath = ".//span[contains(@data-bem, '\"name\":\"reserveReturn\"')]//select")
    private List<SelectBEM> reserveReturnSelectList;

    @Name("Поле для рентабельности инвестиций")
    @FindBy(xpath = ".//span[contains(@data-bem, '\"name\":\"profitability\"')]//input")
    private List<TextInput> profitabilityInputList;

    @Name("Радио выбора подстратегии максимум кликов или максимальная конверсия")
    @FindBy(xpath = ".//span[contains(@data-bem, '\"name\":\"mode\"')]//input")
    private List<RadioBEM> maxClicksOrCPARadioList;

    @Name("Чекбокс включения дополнительной опции стратегии")
    @FindBy(xpath = ".//span[contains(@class,'toggle-row')]//input")
    private List<CheckBoxBEM> extraStrategyOptionCheckbox;
    ///


    //new
    @FindBy(xpath = ".//div[contains(@class, 'b-strategy2-choose__tabbox')]//input")
    @Name("Где показывать везде/поиск/сети")
    private List<RadioBEM> showStrategyRadio;

    protected NewStrategyChooseBlock newStrategyChooseBlock;

    @Name("Раздельно управлять ставками на поиске и в сетях")
    @FindBy(xpath = ".//span[contains(@data-bem, '\"name\":\"isDifferentPlaces\"')]//input")
    private CheckBoxBEM isDifferentPlaces;

    @Name("Поле ошибки при попытке сохранить некорректную стратегию")
    @FindBy(xpath = ".//div[@class='b-strategy2-settings__error']")
    private WebElement errorText;

    private static void fillVisibleSelect(List<SelectBEM> selectList, Integer selectValue) {
        if (selectValue == null) {
            return;
        }
        fillVisibleSelect(selectList, String.valueOf(selectValue));
    }

    private static void fillVisibleSelect(List<SelectBEM> selectList, String selectValue) {
        if (selectValue == null) {
            return;
        }

        SelectBEM currentTextInput = getVisibleElement(selectList);

        currentTextInput.selectByValue(String.valueOf(selectValue));
    }

    private static void fillVisibleTextInput(List<TextInput> inputList, Double input) {
        if (input == null) {
            return;
        }
        fillVisibleTextInput(inputList, String.valueOf(input));
    }

    private static void fillVisibleTextInput(List<TextInput> inputList, Integer input) {
        if (input == null) {
            return;
        }
        fillVisibleTextInput(inputList, String.valueOf(input));
    }

    private static void fillVisibleTextInput(List<TextInput> inputList, String input) {
        if (input == null) {
            return;
        }

        TextInput currentTextInput = getVisibleElement(inputList);

        currentTextInput.clear();
        currentTextInput.sendKeys(String.valueOf(input));
    }

    private DayBudgetBemBlock getDayBudgetBemBlock() {
        dayBudgetBemBlock.setConfig(config);
        return dayBudgetBemBlock;
    }

    private void hideShit() {
        for (WebElement webElement : config.getDriver().findElements(By.cssSelector(".b-floater"))) {
            WebDriverUtils.hideElement(config.getDriver(), webElement);
        }
    }

    @Override
    public void fillStrategy(StrategyInfoWeb bean) {
        hideShit();

        StrategyShowType showType = findOutShowType(bean);
        CampaignStrategyInfoWeb strategy = getExpected(bean);
        StrategyType campaignStrategyType = bean.getCampaignStrategy().getStrategyType();

        if (!showStrategyRadio.isEmpty()) {
            getVisibleElement(showStrategyRadio).selectByValue(showType.getRadioKey());
        }
        if (!bean.getAutoBudget()) {
            //TODO: Сейчас нет полноценной поддержки стратегий CPM кампаний, добавил только одну, для починки теста
            if (bean.getCampaignStrategy().getStrategyType() == CPM_MANUAL_CONTROL) {
                newStrategyChooseBlock.selectStrategy(CPM_MANUAL_CONTROL.getRadioKey());
                return;
            }
            newStrategyChooseBlock.selectStrategy(MANUAL_CONTROL.getRadioKey());
            if (showType != StrategyShowType.NET) {
                if (showType == StrategyShowType.INDEPENDENT) {
                    isDifferentPlaces.select();
                } else if (showType == StrategyShowType.ALL) {
                    isDifferentPlaces.deselect();
                }
                if (campaignStrategyType == StrategyType.DEFAULT) {
                    return;
                }
            }
        } else {
            newStrategyChooseBlock.selectStrategy(strategy.getStrategyType().getRadioKey());

            selectMaxClicksOrCPA(strategy.getStrategyType());
            selectForCampOrFilter(strategy.getStrategyType());
            fillVisibleSelect(strategyGoalSelect, strategy.getGoalID());
            fillVisibleSelect(reserveReturnSelectList, strategy.getReserveReturn());

            toggleExtraStrategyOptions();

            fillVisibleTextInput(avgCpaInputList, strategy.getAverageCPA());
            fillVisibleTextInput(avgCpiInputList, strategy.getAverageCPI());
            fillVisibleTextInput(sumInputList, strategy.getWeeklySumLimit());
            fillVisibleTextInput(limitClicksInputList, strategy.getClicksPerWeek());

            fillVisibleTextInput(clickPriceInputList, strategy.getAveragePrice());
            fillVisibleTextInput(clickPriceInputList, strategy.getMaxPrice());

            if (strategy.getStrategyType() == WEEKLY_PACKET_OF_CLICKS) {
                String clickType = null;
                if (strategy.getAveragePrice() != null) {
                    clickType = StrategyClickPriceType.AVERAGE_PRICE.getTextKey();
                }
                if (strategy.getMaxPrice() != null) {
                    clickType = StrategyClickPriceType.MAX_PRICE.getTextKey();
                }
                fillVisibleSelect(typeOfPriceSelectList, clickType);
            }

            fillVisibleTextInput(cpcPerCampInputList, strategy.getCpcPerCamp());
            fillVisibleTextInput(cpcPerFilterInputList, strategy.getCpcPerFilter());

            fillVisibleTextInput(cpaPerCampInputList, strategy.getCpaPerCamp());
            fillVisibleTextInput(cpaPerFilterInputList, strategy.getCpaPerFilter());

            fillVisibleTextInput(weekBidInputList, strategy.getWeekBid());
            fillVisibleTextInput(maxClickBidInputList, strategy.getMaxClickBid());

            fillVisibleTextInput(roiInputList, strategy.getROICoef());
            fillVisibleSelect(reserveReturnSelectList, strategy.getReserveReturn());
            fillVisibleTextInput(profitabilityInputList, strategy.getProfitability());
        }

    }

    private StrategyShowType findOutShowType(StrategyInfoWeb bean) {
        if (bean.getCampaignStrategy().getStrategyType().equals(StrategyType.SHOWS_DISABLED)) {
            return StrategyShowType.NET;
        }
        if (bean.getCampaignContextStrategy().getStrategyType().equals(StrategyType.SHOWS_DISABLED)) {
            return StrategyShowType.SEARCH;
        }
        if (bean.getCampaignStrategy().getIsIndependentControlStrategy()) {
            return StrategyShowType.INDEPENDENT;
        }
        return StrategyShowType.ALL;
    }

    private StrategyShowType getShowType() {
        if (!showStrategyRadio.isEmpty()) {
            return StrategyShowType.getStrategyShowTypeByValue(getVisibleElement(showStrategyRadio).getSelectedValue());
        } else {
            return StrategyShowType.NET;
        }
    }

    private CampaignStrategyInfoWeb getExpected(StrategyInfoWeb bean) {
        CampaignStrategyInfoWeb expectedValues = null;
        if (bean.getCampaignStrategy().getStrategyType() == SHOWS_DISABLED) {
            expectedValues = new CampaignStrategyInfoWeb();
            copyProperties(expectedValues, bean.getCampaignContextStrategy());
        } else {
            expectedValues = bean.getCampaignStrategy();
        }
        return expectedValues;
    }

    @Override
    public void checkStrategy(StrategyInfoWeb expectedBean) {
        CampaignStrategyInfoWeb expectedValues = getExpected(expectedBean);
        CampaignStrategyInfoWeb actualValues = getStrategy(expectedValues);

        assertThat("неверные параметры стратегии на поиске", actualValues, beanEquals(expectedValues));
        cancelButton.click();
    }

    @Override
    public CampaignStrategyInfoWeb getStrategy(CampaignStrategyInfoWeb expectedBean) {
        CampaignStrategyInfoWeb actualBean = inAccordanceWith(expectedBean).forNew(CampaignStrategyInfoWeb.class)
                .set("weeklySumLimit", this, StrategyBemBlock::getWeeklyBudget)
                .set("clicksPerWeek", this, StrategyBemBlock::getLimitClicks)
                .set("maxPrice", this, t -> t.getClickPrice(StrategyClickPriceType.MAX_PRICE))
                .set("averagePrice", this, t -> t.getClickPrice(StrategyClickPriceType.AVERAGE_PRICE))
                .set("isIndependentControlStrategy", this, StrategyBemBlock::getIsIndependentStrategy)
                .set("averageCPA", this, StrategyBemBlock::getAverageCPA)
                .set("averageCPI", this, StrategyBemBlock::getAverageCPI)
                .set("goalID", this, StrategyBemBlock::getGoalID)
                .set("ROICoef", this, StrategyBemBlock::getRoiCoef)
                .set("reserveReturn", this, StrategyBemBlock::getReserveReturn)
                .set("profitability", this, StrategyBemBlock::getProfitability)
                .set("cpcPerCamp", this, StrategyBemBlock::getCpcPerCamp)
                .set("cpcPerFilter", this, StrategyBemBlock::getCpcPerFilter)
                .set("cpaPerCamp", this, StrategyBemBlock::getCpaPerCamp)
                .set("cpaPerFilter", this, StrategyBemBlock::getCpaPerFilter)
                .set("weekBid", this, StrategyBemBlock::getWeekBid)
                .set("maxClickBid", this, StrategyBemBlock::getMaxClickBid)
                .getActualBean();
        actualBean.setStrategyType(getStrategyType());
        return actualBean;
    }

    public void saveForm() {
        hideShit();
        ((JavascriptExecutor) config.getDriver()).executeScript("arguments[0].click()", saveButton);
    }

    @Override
    public void checkDayBudget(StrategyInfoWeb strategyInfoWeb) {
        hideShit();
        getDayBudgetBemBlock().checkDayBudget(strategyInfoWeb);
    }

    @Override
    public void fillDayBudget(StrategyInfoWeb bean) {
        hideShit();
        log();
        getDayBudgetBemBlock().fillDayBudget(bean);
    }

    @Step
    public void log() {

    }

    @Override
    public void checkDayBudgetBlock(Matcher matcher) {
        assertThat("блок дневного бюджета не соответствует ожиданиям", getDayBudgetBemBlock(), should(matcher)
                .whileWaitingUntil(timeoutHasExpired(TimeUnit.SECONDS.toMillis(
                        DirectTestRunProperties.getInstance().getDirectWebWebdriverImplicityWaitTimeoutSec()))));
    }

    @Override
    public void checkDayBudgetAlert(Matcher<String> matcher) {
        getDayBudgetBemBlock().checkDayBudgetAlertText(matcher);
    }

    @Override
    public void checkErrorText(Matcher<String> matcher) {
        assertThat("текст ошибки соответствует ожидаемому", getErrorText(), matcher);
    }

    @Override
    public ExtendedHtmlElement getStrategyBlock() {
        return this;
    }

    public void clickCancelButton() {
        cancelButton.click();
    }

    private void selectMaxClicksOrCPA(StrategyType type) {
        if (type == null || type.getSubRadioKey() == null || type.getSubRadioKey().equals("") ||
                !Arrays.asList("clicks", "cpa").contains(type.getSubRadioKey()))
        {
            return;
        }

        RadioBEM radio = getVisibleElement(maxClicksOrCPARadioList);

        if (radio == null) {
            return;
        }

        radio.selectByValue(type.getSubRadioKey().replace("-conv", ""));
    }

    private void selectForCampOrFilter(StrategyType type) {
        if (type == null || type.getSubRadioKey() == null || type.getSubRadioKey().equals("") ||
                !Arrays.asList("filter", "camp").contains(type.getSubRadioKey()))
        {
            return;
        }
        RadioBEM targetRadio = getVisibleElement(targetRadioList);

        targetRadio.selectByValue(type.getSubRadioKey());
    }

    public String getGoalID() {
        SelectBEM select = getVisibleElement(strategyGoalSelect);
        if (select == null) {
            return null;
        }
        return select.getSelectedValue();
    }

    public String getReserveReturn() {
        SelectBEM select = getVisibleElement(reserveReturnSelectList);
        if (select == null) {
            return null;
        }
        return select.getSelectedValue();
    }

    public String getClickPrice(StrategyClickPriceType priceType) {
        TextInput input = null;
        try {
            input = getVisibleElement(clickPriceInputList, 1000);
        } catch (DirectWebError e) {
            return "";
        }

        SelectBEM select = null;
        try {
            select = getVisibleElement(typeOfPriceSelectList, 1000);
        } catch (Throwable e) {
            //
        }
        if (select != null && !select.getSelectedValue().equals(priceType.getTextKey())) {
            return null;
        }

        return input.getText();
    }

    public Integer getLimitClicks() {
        TextInput input = getVisibleElement(limitClicksInputList);
        if (input == null) {
            return 0;
        }
        if (input.getText().equals("")) {
            return 0;
        }
        return Integer.parseInt(input.getText());
    }

    public String getWeeklyBudget() {
        TextInput input = getVisibleElement(sumInputList);
        if (input == null) {
            return "";
        }
        return input.getText();
    }

    public String getAverageCPA() {
        TextInput input = getVisibleElement(avgCpaInputList);
        if (input == null) {
            return "";
        }
        return input.getText();
    }

    public String getAverageCPI() {
        TextInput input = getVisibleElement(avgCpiInputList);
        if (input == null) {
            return "";
        }
        return input.getText();
    }

    public String getRoiCoef() {
        TextInput input = getVisibleElement(roiCoefInputList);
        if (input == null) {
            return "";
        }
        return input.getText();
    }

    public String getProfitability() {
        TextInput input = getVisibleElement(profitabilityInputList);
        if (input == null) {
            return "";
        }
        return input.getText();
    }

    public String getCpcPerCamp() {
        TextInput input = getVisibleElement(cpcPerCampInputList);
        return input.getText();
    }

    public String getCpcPerFilter() {
        TextInput input = getVisibleElement(cpcPerFilterInputList);
        return input.getText();
    }

    public String getCpaPerCamp() {
        TextInput input = getVisibleElement(cpaPerCampInputList);
        return input.getText();
    }

    public String getCpaPerFilter() {
        TextInput input = getVisibleElement(cpaPerFilterInputList);
        return input.getText();
    }

    public String getWeekBid() {
        TextInput input = getVisibleElement(weekBidInputList);
        return input.getText();
    }

    public String getMaxClickBid() {
        TextInput input = getVisibleElement(maxClickBidInputList);
        return input.getText();
    }

    private void toggleExtraStrategyOptions() {
        getVisibleElements(extraStrategyOptionCheckbox).forEach(CheckBoxBEM::select);
    }

    public Boolean getIsIndependentStrategy() {
        if (IsDisplayedMatcher.isDisplayed().matches(isDifferentPlaces)) {
            return isDifferentPlaces.isSelected();
        }
        return false;
    }

    private String getErrorText() {
        if (IsDisplayedMatcher.isDisplayed().matches(errorText)) {
            return errorText.getText();
        }
        return "";
    }

    private StrategyType getStrategyType() {
        String selected = newStrategyChooseBlock.getSelectedStrategy();
        String show = getShowType().toString().toLowerCase();
        if ("maximum_clicks".equals(selected)) {
            if ("net".equals(show)) {
                return StrategyType.MAX_COVERADGE;
            }
            if ("all".equals(show) || "search".equals(show)) {
                return StrategyType.HIGHEST_POSITION;
            }
        }
        if ("autobudget_avg_click".equals(selected)) {
            return StrategyType.AVERAGE_PRICE;
        }
        if ("autobudget_avg_cpa".equals(selected)) {
            return StrategyType.AVERAGE_CPA_OPTIMIZATION;
        }
        if ("autobudget_roi".equals(selected)) {
            return StrategyType.ROI_OPTIMIZATION;
        }
        if ("autobudget".equals(selected)) {
            RadioBEM radio = getVisibleElement(maxClicksOrCPARadioList);
            if ("clicks".equals(radio.getSelectedValue())) {
                return StrategyType.WEEKLY_BUDGET_MAX_CLICKS;
            }
            if ("cpa".equals(radio.getSelectedValue())) {
                return StrategyType.WEEKLY_BUDGET_MAX_CONVERSION;
            }
        }
        if ("autobudget_week_bundle".equals(selected)) {
            return StrategyType.WEEKLY_PACKET_OF_CLICKS;
        }
        if ("autobudget_avg_cpi".equals(selected)) {
            return StrategyType.AVERAGE_CPI_OPTIMIZATION;
        }
        if ("autobudget_optimization_cpc".equals(selected)) {
            RadioBEM radio = getVisibleElement(targetRadioList);
            if ("camp".equals(radio.getSelectedValue())) {
                return StrategyType.CPC_CAMPAIGN_OPTIMIZATION;
            }
            if ("filter".equals(radio.getSelectedValue())) {
                return StrategyType.CPC_FILTER_OPTIMIZATION;
            }
        }
        if ("autobudget_optimization_cpa".equals(selected)) {
            RadioBEM radio = getVisibleElement(targetRadioList);
            if ("camp".equals(radio.getSelectedValue())) {
                return StrategyType.CPA_CAMPAIGN_OPTIMIZATION;
            }
            if ("filter".equals(radio.getSelectedValue())) {
                return StrategyType.CPA_FILTER_OPTIMIZATION;
            }
        }
        return StrategyType.UNKNOWN;
    }
}
