package ru.yandex.autotests.direct.web.pages.showcampbem.blocks.strategy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.autotests.direct.web.webelements.bem.CheckBoxBEM;
import ru.yandex.autotests.direct.web.webelements.bem.RadioBEM;
import ru.yandex.autotests.direct.web.webelements.bem.SelectBEM;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.TextInput;

import static java.util.Objects.isNull;
import static org.junit.Assert.assertThat;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.getVisibleElement;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.isExists;

@FindBy(xpath = "//div[contains(@class, 'popup__content')]//div[contains(@class, 'b-campaign-strategy')]")
public class StrategyBlock extends ExtendedHtmlElement {

    //--------------------------------------------
    // Common block

    @Name("Кнопка сохранить")
    @FindBy(xpath = ".//button[contains(@class,'choose__save')]")
    private Button saveButton;

    @Name("Кнопка отмена")
    @FindBy(xpath = ".//button[contains(@class,'choose__cancel')]")
    private Button cancelButton;

    @FindBy(xpath = ".//div[contains(@class, 'b-strategy2-choose__tabbox')]//input")
    @Name("Где показывать везде/поиск/сети")
    private RadioBEM showStrategyModeRadio;

    @Name("Поле ошибки при попытке сохранить некорректную стратегию")
    @FindBy(xpath = ".//div[@class='b-strategy2-settings__error']")
    private List<WebElement> errorText;

    @Name("Выбор стратегии")
    @FindBy(xpath = ".//div[contains(@class, 'b-chooser_theme_strategies-list')]//div[contains(@class, 'b-chooser__text')]")
    private List<WebElement> strategyChooseItems;

    //---------------------------------------
    // Для нескольких стратегий

    // Для всех стратегий

    @Name("Модель атрибуции")
    @FindBy(xpath = ".//div[contains(@class, 'b-strategy2-settings__attribution-model-control')]//select")
    private List<SelectBEM> atributionModel;

    // Оптимизация конверсий, оптимизация рентабельности, Оптимизация кликов

    @Name("Недельный бюджет")
    @FindBy(xpath = ".//span[contains(@data-bem, '\"name\":\"weekBid\"')]//input")
    private List<TextInput> weekBudget;

    @Name("Чекбокс включения уточнения максимальной цены клика")
    @FindBy(xpath = ".//span[contains(@data-bem, '\"name\":\"maxClickBidEnabled\"')]//input")
    private CheckBoxBEM maxClickBidEnabled;

    @Name("Максимальная цена клика")
    @FindBy(xpath = ".//span[contains(@data-bem, '\"name\":\"maxClickBid\"')]//input")
    private List<TextInput> maxClickBid;

    //-----------------------------------------
    // Оптимизация конверсий, оптимизация рентабельности
    @Name("Селект выбора цели")
    @FindBy(xpath = ".//span[contains(@data-bem, '\"name\":\"goalId\"')]//select")
    private List<SelectBEM> strategyGoalSelect;

    //-------------------------------
    // Оптимизация рентабельности, Оптимизация кликов

    @Name("Чекбокс включения уточнения недельного бюджета")
    @FindBy(xpath = ".//span[contains(@data-bem, '\"name\":\"weekBidEnabled\"')]//input")
    private CheckBoxBEM weekBudgetEnabled;

    //----------------------------------------
    // Оптимизация конверсий
    @Name("Средняя цена конверсии")
    @FindBy(xpath = ".//span[contains(@data-bem, '\"name\":\"cpa\"')]//input")
    private TextInput avgConversionPrice;

    //----------------------------------------
    // Оптимизация рентабельности

    @Name("Средняя рентабельность инвестиций")
    @FindBy(xpath = ".//span[contains(@data-bem, '\"name\":\"roi\"')]//input")
    private TextInput avgRoiPrice;

    @Name("Селект выбора процента возврата сэкономленного бюджета")
    @FindBy(xpath = ".//span[contains(@data-bem, '\"name\":\"reserveReturn\"')]//select")
    private SelectBEM returningBudgetPercent;

    @Name("Чекбокс включения уточнения себестоимости товара или услуги")
    @FindBy(xpath = ".//span[contains(@data-bem, '\"name\":\"profitabilityEnabled\"')]//input")
    private CheckBoxBEM profitabilityEnabled;

    @Name("Себестоимость товара или услуги в процентах от дохода")
    @FindBy(xpath = ".//span[contains(@data-bem, '\"name\":\"profitability\"')]//input")
    private TextInput profitability;



    //--------------------------------------
    // Оптимизация кликов

    @Name("Ограничивать по: средней цене клика/недельному бюджету/пакету кликов")
    @FindBy(xpath = ".//span[contains(@class, 'b-strategy2-settings__avg-click-parameter-control')]//label")
    private List<WebElement> restrictionRadio;

    @Name("Средняя цена клика")
    @FindBy(xpath = ".//span[contains(@data-bem, '\"name\":\"avgClickBid\"')]//input")
    private TextInput avgClickPrice;

    @Name("Количество кликов в неделю")
    @FindBy(xpath = ".//span[contains(@data-bem, '\"name\":\"clicksLimit\"')]//input")
    private TextInput clicksLimit;

    @Name("Чекбокс включения цены клика")
    @FindBy(xpath = ".//span[contains(@data-bem, '\"name\":\"clickBidEnabled\"')]//input")
    private CheckBoxBEM clickBidEnabled;

    @Name("Цена клика не более")
    @FindBy(xpath = ".//span[contains(@data-bem, '\"name\":\"clickBid\"')]//input")
    private TextInput clickBid;

    @Name("Селект выбора настройки для цены клика")
    @FindBy(xpath = ".//span[contains(@data-bem, '\"name\":\"clickBidType\"')]//select")
    private SelectBEM clickBidType;

    //----------------------------------------
    // Ручное управление

    @Name("Чекбокс среднего дневного бюджета")
    @FindBy(xpath = ".//span[contains(@data-bem, '\"name\":\"dayBudgetEnabled\"')]//input")
    private CheckBoxBEM dayBudgetEnabled;

    @Name("Дневной бюджет")
    @FindBy(xpath = ".//span[contains(@data-bem, '\"name\":\"sum\"')]//input")
    private TextInput dayBudget;

    @Name("Селект выбора настройки для цены клика")
    @FindBy(xpath = ".//span[contains(@data-bem, '\"name\":\"mode\"')]//select")
    private SelectBEM dayBudgetMode;

    @Name("Чекбокс раздельного управления на поиске и в сетях")
    @FindBy(xpath = ".//span[contains(@data-bem, '\"name\":\"isDifferentPlaces\"')]//input")
    private CheckBoxBEM differentPlacesCheckbox;

    @Name("Чекбокс Удерживать среднюю стоимость клика в сетях ниже, чем на поиске")
    @FindBy(xpath = ".//span[contains(@data-bem, '\"name\":\"enable_cpc_hold\"')]//input")
    private CheckBoxBEM holdAverageClickPrice;

    @Name("Селект выбора сколько тратить в сетях от общего расхода")
    @FindBy(xpath = ".//span[contains(@data-bem, '\"name\":\"contextLimit\"')]//select")
    private SelectBEM contextLimit;

    //----------------------------------------


    //----------------------------------------
    // Блок заполнения и считывания данных

    private void fillSelect(SelectBEM selectList, String selectValue) {
        if (!isExists(selectList)) {
            return;
        }
        selectList.selectByVisibleText(selectValue);
    }

    private void fillVisibleSelect(List<SelectBEM> selectList, String value) {
        SelectBEM currentTextInput = getVisibleElement(selectList);
        fillSelect(currentTextInput, value);
    }

    private void fillTextInput(TextInput textInput, String value) {
        if (value == null || !isExists(textInput)) {
            return;
        }

        textInput.clear();
        textInput.sendKeys(value);
    }

    private void fillTextInput(List<TextInput> textInputs, String value) {
        if (value == null) {
            return;
        }

        TextInput currentTextInput = getVisibleElement(textInputs);
        currentTextInput.clear();
        currentTextInput.sendKeys(value);
    }

    private void fillCheckbox(CheckBoxBEM checkbox, Boolean value) {
        if (!isExists(checkbox) || isNull(value)) {
            return;
        }
        if (value) {
            checkbox.select();
        }
        else {
            checkbox.deselect();
        }
    }

    private String getInputValue(TextInput input) {
        if (!isExists(input)) {
            return null;
        }
        return input.getText();
    }

    private String getInputValue(List<TextInput> inputs) {
        try {
            TextInput input = getVisibleElement(inputs);
            return input.getText();
        }
        catch (DirectWebError e) {
            return null;
        }
    }

    private String getSelectedValue(SelectBEM select) {
        if (!isExists(select)) {
            return null;
        }
        return select.getSelectedText();
    }

    private String getSelectedValue(List<SelectBEM> selects) {
        try {
            SelectBEM select = getVisibleElement(selects);
            return select.getSelectedText();
        }
        catch (DirectWebError e) {
            return null;
        }
    }

    private String getSelectedRadio(RadioBEM radio) {
        //todo костыль, нужно найти способ проверять наличие/отсутствие радио-кнопки
        try {
            return radio.getSelectedValue();
        }
        catch (Exception e) {
            return null;
        }
    }

    private Boolean getSelectedCheckbox(CheckBoxBEM checkbox) {
        if (!isExists(checkbox)) {
            return null;
        }
        return checkbox.isSelected();
    }

    private StrategiesEnum.Strategies getActualStrategyName() {
        String actualStrategy = strategyChooseItems.stream()
                .filter(item -> item.findElement(By.xpath(".//parent::div"))
                        .getAttribute("class")
                        .contains("b-chooser__item_selected_yes"))
                .findFirst()
                .orElseThrow(() -> new DirectWebError("Не найдена элемент с выбранной стратегией"))
                .getText();
        return StrategiesEnum.Strategies.getByTextValue(actualStrategy);
    }

    private void selectRestriction(String restrictionMode) {
        restrictionRadio.stream()
                .filter(mode -> mode.findElement(By.xpath(".//span")).getText().equals(restrictionMode))
                .findFirst()
                .orElseThrow(() -> new DirectWebError("Не найдена кнопка: " + restrictionMode))
                .click();
    }

    private String getRestriction() {
        WebElement checkedButton = restrictionRadio.stream()
                .filter(mode -> mode.getAttribute("class").contains("radio-button__radio_checked_yes"))
                .findFirst()
                .orElse(null);
        if (isNull(checkedButton)) {
            return null;
        }
        else {
            return checkedButton.findElement(By.xpath(".//span")).getText();
        }
    }

    //-----------------------------------------

    public void fillStrategy(StrategyWeb strategy) {

        strategyChooseItems.stream()
                .filter(item -> item.getText().equals(strategy.getStrategy().getValue()))
                .findFirst()
                .orElseThrow(() -> new DirectWebError("Не удалось найти стратегию: " + strategy.getStrategy().getValue()))
                .click();


        if (isExists(showStrategyModeRadio)) {
            showStrategyModeRadio.selectByValue(strategy.getShowsType().getRadioKey());
        }

        switch (strategy.getStrategy()) {
            case OPTIMIZE_CONVERSIONS:
                if (!isNull(strategy.getAtributionModel())) {
                    fillVisibleSelect(atributionModel, strategy.getAtributionModel().getValue());
                }
                fillVisibleSelect(strategyGoalSelect, strategy.getGoal());
                fillTextInput(avgConversionPrice, strategy.getAverageConversionPrice());
                fillTextInput(weekBudget, strategy.getWeekBudget());
                if (maxClickBidEnabled.isDisplayed() && !maxClickBidEnabled.isSelected() && !isNull(strategy.getMaxClickBid())) {
                    maxClickBidEnabled.select();
                }
                fillTextInput(maxClickBid, strategy.getMaxClickBid());
                break;

            case OPTIMIZE_ROI:
                if (!isNull(strategy.getAtributionModel())) {
                    fillVisibleSelect(atributionModel, strategy.getAtributionModel().getValue());
                }
                fillTextInput(avgRoiPrice, strategy.getAverageRoiPrice());
                fillVisibleSelect(strategyGoalSelect, strategy.getGoal());
                fillSelect(returningBudgetPercent, strategy.getReturningBudgetPercent());

                if (profitabilityEnabled.isDisplayed() && !profitabilityEnabled.isSelected() && !isNull(strategy.getProfitability())) {
                    profitabilityEnabled.select();
                }
                fillTextInput(profitability, strategy.getProfitability());

                if (weekBudgetEnabled.isDisplayed() && !weekBudgetEnabled.isSelected() && !isNull(strategy.getWeekBudget())) {
                    weekBudgetEnabled.select();
                }
                fillTextInput(weekBudget, strategy.getWeekBudget());
                if (!maxClickBidEnabled.isSelected() && !isNull(strategy.getMaxClickBid())) {
                    maxClickBidEnabled.select();
                }
                fillTextInput(maxClickBid, strategy.getMaxClickBid());
                break;

            case OPTIMIZE_CLICKS:
                if (!isNull(strategy.getAtributionModel())) {
                    fillVisibleSelect(atributionModel, strategy.getAtributionModel().getValue());
                }
                if (!isNull(restrictionRadio)) {
                    selectRestriction(strategy.getRestriction().getRadioKey());
                }
                fillTextInput(avgClickPrice, strategy.getAverageClickPrice());

                if (weekBudgetEnabled.isDisplayed() && !weekBudgetEnabled.isSelected() && !isNull(strategy.getWeekBudget())) {
                    weekBudgetEnabled.select();
                }
                fillTextInput(weekBudget, strategy.getWeekBudget());
                if (maxClickBidEnabled.isDisplayed() && !maxClickBidEnabled.isSelected() && !isNull(strategy.getMaxClickBid())) {
                    maxClickBidEnabled.select();
                }
                fillTextInput(maxClickBid, strategy.getMaxClickBid());
                fillTextInput(clicksLimit, strategy.getClicksLimit());
                if (clickBidEnabled.isDisplayed() && !clickBidEnabled.isSelected() && !isNull(strategy.getClicksBid())) {
                    clickBidEnabled.select();
                }
                if (!isNull(strategy.getClicksBidType())) {
                    fillSelect(clickBidType, strategy.getClicksBidType().getValue());
                }
                fillTextInput(clickBid, strategy.getClicksBid());
                break;
            case MANUAL_BID_MANAGEMENT:
                if (!isNull(strategy.getAtributionModel())) {
                    fillVisibleSelect(atributionModel, strategy.getAtributionModel().getValue());
                }
                if (dayBudgetEnabled.isDisplayed() && !dayBudgetEnabled.isSelected()  && !isNull(strategy.getDayBudget())) {
                    dayBudgetEnabled.select();
                }
                fillTextInput(dayBudget, strategy.getDayBudget());
                if (!isNull(strategy.getDayBudgetType())) {
                    fillSelect(dayBudgetMode, strategy.getDayBudgetType().getValue());
                }
                fillCheckbox(differentPlacesCheckbox, strategy.getDifferentPlacesControl());
                if (!isNull(strategy.getHoldAverageClickPrice())) {
                    fillCheckbox(holdAverageClickPrice, strategy.getHoldAverageClickPrice());
                }
                if (!isNull(strategy.getContextLimit())) {
                    fillSelect(contextLimit, strategy.getContextLimit().getValue());
                }
                break;
        }
    }

    public StrategyWeb getStrategy() {
        StrategyWeb actualStrategy = new StrategyWeb()
                .withStrategy(getActualStrategyName())
                .withShowsType(StrategiesEnum.StrategyShowsType.getStrategyShowTypeByValue(getSelectedRadio(showStrategyModeRadio)));

        switch (actualStrategy.getStrategy()) {
            case OPTIMIZE_CONVERSIONS:
                actualStrategy
                        .withAtributionModel(StrategiesEnum.AtributionModel.getAtributionModelValue(getSelectedValue(atributionModel)))
                        .withGoal(getSelectedValue(strategyGoalSelect))
                        .withAverageConversionPrice(getInputValue(avgConversionPrice))
                        .withWeekBudget(getInputValue(weekBudget))
                        .withMaxClickBid(getInputValue(maxClickBid));
                break;

            case OPTIMIZE_ROI:
                actualStrategy
                        .withAtributionModel(StrategiesEnum.AtributionModel.getAtributionModelValue(getSelectedValue(atributionModel)))
                        .withAverageRoiPrice(getInputValue(avgRoiPrice))
                        .withGoal(getSelectedValue(strategyGoalSelect))
                        .withReturningBudgetPercent(getSelectedValue(returningBudgetPercent))
                        .withProfitability(getInputValue(profitability))
                        .withWeekBudget(getInputValue(weekBudget))
                        .withMaxClickBid(getInputValue(maxClickBid));
                break;

            case OPTIMIZE_CLICKS:
                actualStrategy
                        .withAtributionModel(StrategiesEnum.AtributionModel.getAtributionModelValue(getSelectedValue(atributionModel)))
                        .withRestriction(StrategiesEnum.Restriction.getRestrictionByValue(getRestriction()))
                        .withAverageClickPrice(getInputValue(avgClickPrice))
                        .withWeekBudget(getInputValue(weekBudget))
                        .withMaxClickBid(getInputValue(maxClickBid))
                        .withClicksLimit(getInputValue(clicksLimit))
                        .withClicksBidType(StrategiesEnum.ClicksBidType.getClicksBidTypeByValue(getSelectedValue(clickBidType)))
                        .withClicksBid(getInputValue(clickBid));
                break;
            case MANUAL_BID_MANAGEMENT:
                actualStrategy
                        .withAtributionModel(StrategiesEnum.AtributionModel.getAtributionModelValue(getSelectedValue(atributionModel)))
                        .withDayBudget(getInputValue(dayBudget))
                        .withDayBudgetType(StrategiesEnum.DayBudgetType.getDayBudgetTypeByValue(getSelectedValue(dayBudgetMode)))
                        .withDifferentPlacesControl(getSelectedCheckbox(differentPlacesCheckbox))
                        .withHoldAverageClickPrice(getSelectedCheckbox(holdAverageClickPrice))
                        .withContextLimit(StrategiesEnum.ContextLimitValue.getContextLimitValue(getSelectedValue(contextLimit)));
                break;
        }

        return actualStrategy;
    }

    public void checkStrategy(StrategyWeb expectedStrategy) {
        StrategyWeb actualStrategy = getStrategy();

        assertThat("параметры стратегии соответствуют ожидаемым", actualStrategy, beanEquals(expectedStrategy));
    }

    public void clickSaveButton() {
        saveButton.click();
    }

    public void clickCancelButton() {
        cancelButton.click();
    }

    public String getErrorText() {
        return getVisibleElement(errorText).getText();
    }
}