package ru.yandex.autotests.direct.web.pages.smartbanners;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import ru.yandex.autotests.direct.web.pages.smartbanners.blocks.CreativeBannerRowBlock;
import ru.yandex.autotests.direct.web.pages.smartbanners.blocks.CreativesViewModeEnum;
import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.autotests.direct.web.webelements.bem.RadioBEM;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrl;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrls;
import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.TextInput;
import ru.yandex.qatools.htmlelements.matchers.WebElementMatchers;

import java.util.List;

import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.direct.web.steps.CommonSteps.waitForElement;

@NamedUrls({
        @NamedUrl(name = "open.show.creatives.for.login", url = "/registered/main.pl?cmd=showCreatives&ulogin={1}"),
        @NamedUrl(name = "open.show.creatives.with.page.number",
                url = "/registered/main.pl?cmd=showCreatives&ulogin={1}&page={2}"),
})
public class ShowCreativesPage extends BasePageObject {

    @Name("Поле поиска баннеров по номеру/названию")
    @FindBy(xpath = ".//div[contains(@class, 'b-creative-list-filters__search')]//input")
    private TextInput searchBannersInput;

    @Name("Кнопка применить (поиск)")
    @FindBy(xpath = ".//button[contains(@class, 'b-creative-list-filters__apply-btn')]")
    private Button applySearch;

    @Name("Переключатель группы/список")
    @FindBy(xpath = ".//div[contains(@class, 'b-switcher-group-list-view')]//input")
    private RadioBEM creativeViewMode;

    @Name("Элемент ожидания ответа от сервера поиска креативов (паранжа)")
    @FindBy(xpath = ".//div[@class = 'creative-list__paranja']")
    private WebElement paranjaWebElement;

    private List<CreativeBannerRowBlock> creativeBannerRowBlockList;

    public void searchCreative(Long creativeId) {
        waitForElement(paranjaWebElement, 5, not(WebElementMatchers.isDisplayed()));
        searchBannersInput.clear();
        searchBannersInput.sendKeys(creativeId.toString());
        applySearch.click();
        waitForElement(paranjaWebElement, 5, not(WebElementMatchers.isDisplayed()));
    }

    private CreativeBannerRowBlock getBannerRowBlock(Long bannerId) {
        creativeViewMode.selectByValue("list");
        searchCreative(bannerId);
        return creativeBannerRowBlockList.stream()
                .filter(t -> t.getBannerId().equals(bannerId)).findFirst()
                .orElseThrow(() -> new DirectWebError("Не найден баннер " + bannerId));
    }

    public void openInfoAboutRejectionPopup(Long bannerId) {
        getBannerRowBlock(bannerId).openMoreAboutModerationRejectionPopup();
    }

    public WebElement getBannerRow(Long bannerId) {
        return getBannerRowBlock(bannerId);
    }

    public void selectViewMode(CreativesViewModeEnum mode) {
        creativeViewMode.selectByValue(mode.getViewMode());
        waitForElement(paranjaWebElement, 5, not(WebElementMatchers.isDisplayed()));
    }
}
