package ru.yandex.autotests.direct.web.pages.smartbanners.blocks;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.HtmlElement;

import static java.lang.Long.parseLong;

@Name("Сохраненное условие подбора аудиторий")
@FindBy(xpath = "//li[contains(@class, 'b-dynamic-media-creative-list')]")
public class CreativeBannerRowBlock extends HtmlElement {
    @Name("id баннера")
    @FindBy(xpath = ".//div[contains(@class, 'b-dynamic-media-creative__field-value_name_id')]")
    private WebElement bannerId;

    @Name("Кнопка редактирования баннера")
    @FindBy(xpath = ".//button[contains(@class, 'b-dynamic-media-creative__edit')]")
    private Button editBannerButton;

    @Name("Подробнее о причинах отклонения")
    @FindBy(xpath = ".//div[contains(@class,'b-dynamic-media-creative__status-text-more')]/span")
    private WebElement moreAboutModerationRejection;

    public Long getBannerId() {
        return parseLong(bannerId.getText());
    }

    public void openMoreAboutModerationRejectionPopup() {
        moreAboutModerationRejection.click();
    }
}
