package ru.yandex.autotests.direct.web.pages.statistic;


import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import ru.yandex.autotests.direct.web.data.SelectInputMethod;
import ru.yandex.autotests.direct.web.data.statistic.NewReportFilterInfoWeb;
import ru.yandex.autotests.direct.web.data.statistic.NewReportInfoWeb;
import ru.yandex.autotests.direct.web.data.statistic.StatisticType;
import ru.yandex.autotests.direct.web.pages.statistic.blocks.StatisticsBannerPreviewBlockBEM;
import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.autotests.direct.web.webelements.bem.CalendarInputBEM;
import ru.yandex.autotests.direct.web.webelements.bem.CheckBoxBEM;
import ru.yandex.autotests.direct.web.webelements.bem.SelectBEM;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrl;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrls;
import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.Link;
import ru.yandex.qatools.htmlelements.element.TextInput;
import ru.yandex.qatools.htmlelements.matchers.WebElementMatchers;

import java.util.Date;
import java.util.List;

import static org.apache.commons.lang3.StringUtils.join;
import static ru.yandex.autotests.direct.web.steps.BackendSteps.toBoolean;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.*;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */

//пока на bem переведена только вкладка 'Статистика по дням' https://jira.yandex-team.ru/browse/TESTIRT-2065
@NamedUrls({
        @NamedUrl(name = "campaign.stat", url = "/registered/main.pl?cmd=showCampStat&cid={1}&interface=std"),
        @NamedUrl(name = "campaign.stat.for.login",
                url = "/registered/main.pl?cmd=showCampStat&cid={1}&ulogin={2}&interface=std"),
        @NamedUrl(name = "campaign.stat.light", url = "cmd=showCampStat&detail=Yes&cid={1}" +
                "&showCampStat=cmd&types=days&target_all=1"),
        @NamedUrl(name = "campaign.stat.light.for.login", url = "/registered/main.pl?c" +
                "md=showCampStat&detail=Yes&cid={1}&ulogin={2}&showCampStat=cmd&types=days&target_all=1"),
        @NamedUrl(name = "campaign.stat.with.params", url = "/registered/main.pl?cmd=showCampStat&cid={1}&{2}"),
        @NamedUrl(name = "all.campaigns.stat.for.login",
                url = "/registered/main.pl?cmd=showCampStat&ulogin={1}&stat_type=campdate"),
        @NamedUrl(name = "wizard.for.campaign.and.login",
                url = "/registered/main.pl?cmd=showCampStat&cid={1}&ulogin={2}&stat_type=custom&target_all=1")
})
public class ShowCampStatPageBEM extends BasePageObject {


    @Name("Табы типов статистики")
    @FindBy(xpath = ".//div[contains(@class, 'b-campaign-tabs__tab')]/*[contains(@class, 'link')]")
    private List<Link> statisticTabs;

    @Name("Статистика с")
    @FindBy(xpath = ".//span[contains(@class, 'b-date-range-picker__start')]")
    private CalendarInputBEM dateFrom;

    @Name("Статистика по")
    @FindBy(xpath = ".//span[contains(@class, 'b-date-range-picker__finish')]")
    private CalendarInputBEM dateTo;

    @Name("Группировка")
    @FindBy(name = "group")
    private SelectBEM filterGroup;

    @Name("Данные по цели")
    @FindBy(name = "goals")
    private SelectBEM goalData;

    @Name("Площадки всего")
    @FindBy(id = "target_all")
    private CheckBoxBEM sitesTotal;

    @Name("На поиске")
    @FindBy(id = "target_0")
    private CheckBoxBEM sitesSearch;

    @Name("Контекст")
    @FindBy(id = "target_1")
    private CheckBoxBEM sitesContext;

    @Name("НДС")
    @FindBy(name = "with_nds")
    private CheckBoxBEM vat;

    @Name("Детальная статистика по объявлениям")
    @FindBy(name = "show_banners_stat")
    private CheckBoxBEM showBannerStatInDetail;

    @Name("Чекбокс 'Метки'")
    @FindBy(xpath = ".//input[@value='tag']")
    private CheckBoxBEM groupByTag;

    @Name("Фильтр меток")
    @FindBy(name = "filter_tag")
    private TextInput filterTag;

    @Name("Чекбокс 'Группы'")
    @FindBy(xpath = ".//input[@value='adgroup']")
    private CheckBoxBEM groupByADGroup;

    @Name("Фильтр групп")
    @FindBy(name = "filter_adgroup")
    private TextInput filterADGroup;

    @Name("Чекбокс '№ Объявления'")
    @FindBy(xpath = ".//input[@value='banner']")
    private CheckBoxBEM groupByBanner;

    @Name("Фильтр объявлений")
    @FindBy(name = "filter_banner")
    private TextInput filterBanner;

    @Name("Чекбокс 'Площадки'")
    @FindBy(xpath = ".//input[@value='page']")
    private CheckBoxBEM groupByPage;

    @Name("Фильтр площадок")
    @FindBy(name = "filter_page")
    private TextInput filterPage;

    @Name("Селект выбора площадки")
    @FindBy(name = "filter_page_target")
    private SelectBEM filterPageTarget;

    @Name("Чекбокс 'Подробно'")
    @FindBy(name = "use_page_id")
    private CheckBoxBEM filterPageInDetail;

    @Name("Чекбокс 'Фразы'")
    @FindBy(xpath = ".//input[@value='phrase']")
    private CheckBoxBEM groupByPhrase;

    @Name("Фльтр фраз")
    @FindBy(name = "filter_phrase")
    private TextInput filterPhrase;

    @Name("Чекбокс 'Условия ретаргетинга'")
    @FindBy(xpath = ".//input[@value='retargeting']")
    private CheckBoxBEM groupByRetargeting;

    @Name("Фильтр условий ретаргетинга")
    @FindBy(name = "filter_retargeting")
    private TextInput filterRetargeting;

    @Name("Чекбокс 'Регионы'")
    @FindBy(xpath = ".//input[@value='geo']")
    private CheckBoxBEM groupByGeo;

    @Name("Фильтр регионов")
    @FindBy(name = "filter_geo")
    private TextInput filterGeo;

    @Name("Чекбокс 'Позиция'")
    @FindBy(xpath = ".//input[@value='position']")
    private CheckBoxBEM groupByPosition;

    @Name("Выбор позиции")
    @FindBy(name = "filter_position")
    private SelectBEM filterPosition;

    @Name("Чекбокс 'Изображение'")
    @FindBy(xpath = ".//input[@value='image']")
    private CheckBoxBEM groupByImage;

    @Name("Выбор фильтра по изображению")
    @FindBy(name = "filter_image")
    private SelectBEM filterImage;

    @Name("Чекбокс группировки по дате")
    @FindBy(xpath = ".//input[@value='date']")
    private CheckBoxBEM groupByDate;

    @Name("Селект Показать строк на странице ")
    @FindBy(name = "onpage")
    private SelectBEM linesPerPage;

    @Name("Кнопка 'Показать'")
    @FindBy(xpath = ".//button[contains(@class, 'b-statistics-form__submit-button')]")
    private Button show;

    @Name("Показать дополнительные настройки")
    @FindBy(xpath = ".//label[contains(@class, 'b-statistics-form__show-button')]")
    private WebElement showAdditionalParameters;

    @Name("Список превью банеров")
    private List<StatisticsBannerPreviewBlockBEM> bannerPreviewBlocks;

    @Name("Список ссылок на баннеры для статистики по мастеру отчетов")
    @FindBy(css = "div.b-group-preview2-opener span.link__inner")
    private List<Link> statisticsWizardBannerLinks;

    @Name("Таблица со статистикой")
    @FindBy(xpath="(.//table[contains(@class,'b-stat-table')])[1]")
    private WebElement statisticsTable;

    @Name("Шапка страницы со статистикой")
    @FindBy(xpath=".//table[contains(@class,'p-campaign-stat__head-layout')]")
    private WebElement statisticsHead;

    @Name("Шапка таблицы статистики, которая 'уплывает при скролле'")
    @FindBy(xpath=".//tr[contains(@class,'b-stat-table__head_floating_yes')]")
    private WebElement statTableHead;

    public WebElement getStatisticsTable() {
        return statisticsTable;
    }

    public WebElement getStatisticsHead() {
        return statisticsHead;
    }

    public WebElement getStatTableHead() {
        return statTableHead;
    }

    private Link getTab(StatisticType statisticType) {
        for (Link statisticTab : statisticTabs) {
            if (statisticTab.getReference().contains(statisticType.getLinkPart())) {
                return statisticTab;
            }
        }
        return null;
    }

    public void clickTab(StatisticType type) {
        getTab(type).click();
    }

    public void clickShow() {
        show.click();
    }

    public void fillStatisticRequestInfo(NewReportInfoWeb info) {
        if (WebElementMatchers.isDisplayed().matches(showAdditionalParameters)) {
            showAdditionalParameters.click();
        }
        fillDateFrom(info.getStartDate());
        fillDateTo(info.getEndDate());
        fillSelect(filterGroup, info.getGroupByDate(), SelectInputMethod.BY_VALUE);
        fillSelect(goalData, info.getGoal(), SelectInputMethod.BY_VALUE);
        setCheckboxState(sitesTotal, info.getSitesTotal());
        setCheckboxState(sitesSearch, info.getSitesSearch());
        setCheckboxState(sitesContext, info.getSitesContext());
        setCheckboxState(vat, toBoolean(info.getIncludeVat()));
        setCheckboxState(showBannerStatInDetail, info.getShowBannerStatInDetail());
        fillSelect(linesPerPage, info.getLinesPerPage(), SelectInputMethod.BY_VALUE);
        fillFilterParameters(info.getNewReportFilterInfoWeb());
    }

    private void fillFilterParameters(NewReportFilterInfoWeb filter) {
        if (filter == null)
            return;
        fillFilter(groupByTag, filterTag, filter.getTags());
        fillFilter(groupByADGroup, filterADGroup, filter.getAdGroups());
        fillFilter(groupByBanner, filterBanner, filter.getBanner());
        if (filter.getPageName() != null) {
            fillFilter(groupByPage, filterPage, filter.getPageName());
            fillSelect(filterPageTarget, filter.getPageType(), SelectInputMethod.BY_VALUE);
            setCheckboxState(filterPageInDetail, filter.getSitesInDetail());
        }
        fillFilter(groupByPhrase, filterPhrase, filter.getPhrase());
        fillFilter(groupByRetargeting, filterRetargeting, filter.getStatGoals());
        fillFilter(groupByGeo, filterGeo, filter.getGeo());
        if (filter.getPositionType() != null) {
            groupByPosition.select();
            fillSelect(filterPosition, filter.getPositionType(), SelectInputMethod.BY_VALUE);
        } else {
            groupByPosition.deselect();
        }
        if (filter.getWithImage() != null) {
            groupByImage.select();
            fillSelect(filterImage, filter.getWithImage(), SelectInputMethod.BY_VALUE);
        } else {
            groupByImage.deselect();
        }
        if (filter.getGroupByDate() != null) {
            groupByDate.select();
            fillSelect(filterGroup, filter.getGroupByDate(), SelectInputMethod.BY_VALUE);
        } else {
            groupByDate.deselect();
        }
    }

    private void fillDateFrom(Date date) {
        if (date == null)
            return;
        dateFrom.fillDate(date);
    }

    private void fillDateTo(Date date) {
        if (date == null)
            return;
        dateTo.fillDate(date);
    }

    private void fillFilter(CheckBoxBEM checkBox, TextInput filterInput, List values) {
        if (values == null)
            return;
        if (values.size() > 0) {
            checkBox.select();
            fillTextInput(filterInput, join(values, ","));
        } else {
            checkBox.deselect();
        }
    }

    private StatisticsBannerPreviewBlockBEM getBannerPreviewBlock(Long bannerId) {
        return bannerPreviewBlocks.stream().filter(b -> b.getBannerId().equals(bannerId)).findFirst()
                .orElseThrow(() -> new DirectWebError("Не найден баннер " + bannerId));
    }

    public void openImagePopup(Long bannerId) {
        getBannerPreviewBlock(bannerId).clickOnOpenImagePopup();
    }

    private Link getStatisticsWizardBannerLink(Long bannerId) {
        return statisticsWizardBannerLinks.stream().filter(b -> b.getText().contains(bannerId.toString())).findFirst()
                .orElseThrow(() -> new DirectWebError("Не найден баннер " + bannerId));
    }

    public void clickOnStatisticsWizardBannerLink(Long bannerId) {
        getStatisticsWizardBannerLink(bannerId).click();
    }
}
