package ru.yandex.autotests.direct.web.pages.statistic.blocks;

import java.util.List;

import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.data.SelectInputMethod;
import ru.yandex.autotests.direct.web.objects.statistic.StatisticMinusPhraseInfoWeb;
import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.autotests.direct.web.util.matchers.IsDisplayedMatcher;
import ru.yandex.autotests.direct.web.util.testinterfaces.IWebFrom;
import ru.yandex.autotests.direct.web.webelements.bem.SelectBEM;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.TextInput;

import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillSelect;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillTextInput;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.getFirstElementMatches;

@Name("Блок фразы в попапе добавления минус-фраз")
@FindBy(css = "div.b-minus-phrases-manager__phrase-item")
public class EditMinusPhraseRow extends ExtendedHtmlElement implements IWebFrom<StatisticMinusPhraseInfoWeb> {

    @Name("Текст минус-фразы")
    @FindBy(xpath = ".//span[@class='input__box']//input")
    private TextInput textPhraseInput;

    @Name("Назначение добавления минус-фразы")
    @FindBy(xpath = ".//span[contains(@class, 'b-minus-phrases-manager__phrase-item-target')]//select")
    private List<SelectBEM> minusPhraseTarget;

    private SelectBEM getMinusPhraseTarget() {
        return getFirstElementMatches(minusPhraseTarget, IsDisplayedMatcher.isDisplayed());
    }

    private TextInput getTextPhraseInput() {
        return textPhraseInput;
    }

    @Override
    public void fillParameters(StatisticMinusPhraseInfoWeb bean) {
        fillTextInput(getTextPhraseInput(), bean.getText());
        fillSelect(getMinusPhraseTarget(), bean.getTarget(), SelectInputMethod.BY_VALUE);
    }

    @Override
    public void checkParameters(StatisticMinusPhraseInfoWeb expectedBean) {
        throw new UnsupportedOperationException();
    }

    @Override
    public StatisticMinusPhraseInfoWeb getFormFieldsAccording(StatisticMinusPhraseInfoWeb expectedBean) {
        throw new UnsupportedOperationException();
    }
}
