package ru.yandex.autotests.direct.web.pages.statistic.blocks;

import org.openqa.selenium.support.FindBy;
import ru.yandex.autotests.direct.web.objects.banners.BannerPhraseInfoWeb;
import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.autotests.direct.web.util.WebElementsActions;
import ru.yandex.autotests.direct.web.webelements.NumericInput;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.TextInput;

import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillTextInput;

@Name("Блок фразы в попапе добавления фраз")
@FindBy(css = "div.b-stat-phrases-manager__phrase-item")
public class EditPhraseRow extends ExtendedHtmlElement {

    @Name("Текст фразы")
    @FindBy(xpath = ".//span[contains(@class, 'b-stat-phrases-manager__phrase')]//input")
    private TextInput textPhraseInput;

    @Name("Ставка фразы")
    @FindBy(css = "input.b-edit-phrase-price__control")
    private NumericInput pricePhraseInput;

    public void fillParameters(BannerPhraseInfoWeb phraseInfoWeb){
        if (phraseInfoWeb.getPhrase() == null)
            return;
        fillTextInput(textPhraseInput, phraseInfoWeb.getPhrase());
        if (phraseInfoWeb.getPrice() == null)
            return;
        new WebElementsActions(config).setNumericValue(pricePhraseInput, phraseInfoWeb.getPrice());
    }
}
