package ru.yandex.autotests.direct.web.pages.statistic.blocks;

import java.util.List;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.objects.banners.BannerPhraseInfoWeb;
import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.autotests.direct.web.util.StringHelper;
import ru.yandex.autotests.direct.web.webelements.bem.CheckBoxBEM;
import ru.yandex.qatools.htmlelements.annotations.Name;

import static java.lang.Long.parseLong;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.setCheckboxState;

@Name("Блок с фразами в статистике поисковых запросов")
@FindBy(xpath = ".//tr[contains(@class, 'b-stat-table__row_detailed-row')]")
public class StatisticSearchQueriesRowBlock extends ExtendedHtmlElement {

    @Name("Чекбокс фразы")
    @FindBy(xpath = ".//span[@class='checkbox__box']//input")
    private CheckBoxBEM checkbox;

    @Name("Поисковый запрос")
    @FindBy(css = "div.b-mol-stat-data__search-query-wrap")
    private WebElement phrase;

    @Name("Номер группы")
    @FindBy(xpath = ".//td[contains(@class, 'b-stat-table__row-col_content-type_adgroup') and not(contains(@class, 'adgroup-name'))]")
    private WebElement adGroupId;

    @Name("Номер объявления")
    @FindBy(xpath = ".//td[contains(@class, 'b-stat-table__row-col_content-type_banner')]//span[@class='link__inner']")
    private WebElement bannerId;

    @Name("Id кампании")
    @FindBy(css = ".b-stat-table__row-col_content-type_campaign")
    private List<WebElement> campaignId;

    public void setCheckbox(Boolean state) {
        setCheckboxState(checkbox, state);
    }

    public Long getAdGroupId() {
        return parseLong(adGroupId.getText().trim());
    }

    public String getPhraseText() {
        return phrase.getText().trim();
    }

    public Long getBannerId() {
        return StringHelper.getNumericDataFromText(bannerId.getText()).get(0);
    }

    public Long getCampaignId() {
        return campaignId.isEmpty() ? null :
                StringHelper.getNumericDataFromText(campaignId.get(0).getText()).get(0);
    }

    public BannerPhraseInfoWeb getBean() {
        return new BannerPhraseInfoWeb()
                .withAdGroupID(getAdGroupId())
                .withPhrase(getPhraseText())
                .withCampaignId(getCampaignId())
                .withBannerId(getBannerId());
    }
}
