package ru.yandex.autotests.direct.web.pages.statistic.blocks;

import java.util.List;
import java.util.stream.IntStream;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.objects.statistic.StatisticMinusPhraseInfoWeb;
import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.matchers.WebElementMatchers;

import static java.util.Objects.isNull;
import static org.hamcrest.Matchers.not;
import static org.hamcrest.collection.IsCollectionWithSize.hasSize;
import static ru.yandex.autotests.direct.web.steps.CommonSteps.waitForElement;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Name("Попап добавления минус-фраз в статистике")
@FindBy(xpath = ".//div[contains(@class, 'popup_visibility_visible')]//div[contains(@class, 'b-stat-table-phrases-popup_type_minus')]")
public class StatisticsAddMinusPhrasesPopup extends ExtendedHtmlElement {

    @Name("Сохранить поисковый запрос в минус-фразы")
    @FindBy(xpath = ".//button[contains(@class, 'b-stat-table-phrases-popup__save')]")
    private WebElement saveButton;

    @Name("Крутящаяся заглушка при загрузке")
    @FindBy(xpath = ".//div[contains(@class, 'b-stat-table-phrases-popup__spin')]")
    private WebElement spinLoader;

    private List<EditMinusPhraseRow> minusPhraseRows;

    public void fillMinusPhraseParameters(List<StatisticMinusPhraseInfoWeb> minusPhraseInfoList) {
        waitForElement(spinLoader, 10, not(WebElementMatchers.isDisplayed()));
        assumeThat("длина аргумента соответствует ожидаемому", minusPhraseInfoList, hasSize(minusPhraseRows.size()));
        IntStream.range(0, minusPhraseInfoList.size())
                .forEach(i -> {
                    EditMinusPhraseRow editPhraseRow = minusPhraseRows.get(i);
                    editPhraseRow.setConfig(config);
                    editPhraseRow.fillParameters(minusPhraseInfoList.get(i));
                });
        clickSave();
    }

    public void clickSave() {
        saveButton.click();
    }
}
