package ru.yandex.autotests.direct.web.pages.statistic.blocks;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import ru.yandex.autotests.direct.web.objects.banners.BannerPhraseInfoWeb;
import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.matchers.WebElementMatchers;

import java.util.List;
import java.util.stream.IntStream;

import static java.util.Objects.isNull;
import static org.hamcrest.CoreMatchers.not;
import static org.hamcrest.collection.IsCollectionWithSize.hasSize;
import static ru.yandex.autotests.direct.web.steps.CommonSteps.waitForElement;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Name("Попап добавления фраз в статистике")
@FindBy(xpath = ".//div[contains(@class, 'popup_visibility_visible')]//div[contains(@class, 'b-stat-table-phrases-popup')]")
public class StatisticsAddPhrasePopup extends ExtendedHtmlElement {

    @Name("Сохранить поисковый запрос в ключевые фразы")
    @FindBy(xpath = ".//button[contains(@class, 'b-stat-table-phrases-popup__save')]")
    private WebElement saveButton;

    private List<EditPhraseRow> phraseRows;

    public void fillPhraseParameters(List<BannerPhraseInfoWeb> phraseInfoList) {
        waitForElement(phraseRows.get(0), 3, WebElementMatchers.isDisplayed());
        takeScreenshot();
        assumeThat("длина аргумента соответствует ожидаемому", phraseInfoList, hasSize(phraseRows.size()));
        IntStream.range(0, phraseInfoList.size())
                .filter(i -> !isNull(phraseInfoList.get(i)))
                .forEach(i -> {
                    EditPhraseRow editPhraseRow = phraseRows.get(i);
                    editPhraseRow.setConfig(config);
                    editPhraseRow.fillParameters(phraseInfoList.get(i));
                });
    }

    public void clickSave() {
        saveButton.click();
    }
}
