package ru.yandex.autotests.direct.web.pages.statistic.blocks;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import ru.yandex.autotests.direct.web.util.StringHelper;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.HtmlElement;

/**
 * @author: Alex Samokhin (alex-samo@yandex-team.ru)
 * Date: 06.06.14
 */

@FindBy(xpath = ".//td[contains(@class, 'b-stat-table__title-col')  and ./div[contains(@class,'b-stat-banner')]]")
public class StatisticsBannerPreviewBlockBEM extends HtmlElement {

    @Name("ID баннера")
    @FindBy(xpath = ".//div[contains(@class, 'b-stat-banner__banner-bid')]")
    private WebElement bannerId;

    @Name("Ссылка на попап с изображением")
    @FindBy(xpath = ".//span[contains(@class, 'b-banner-preview2__addition')]")
    private WebElement openImagePopupLink;


    public void clickOnOpenImagePopup() {
        openImagePopupLink.click();
    }

    public Long getBannerId() {
        return StringHelper.getNumericDataFromText(bannerId.getText()).get(0);
    }
}
