package ru.yandex.autotests.direct.web.pages.statistic.blocks;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.webelements.bem.CheckBoxBEM;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.HtmlElement;

import static ru.yandex.autotests.direct.web.util.WebElementsActions.setCheckboxState;

@FindBy(xpath = ".//div[contains(@class,'b-statistic-columns-slices__item_type_columns')]")
public class StatisticsReportWizardColumnsBlock extends HtmlElement {

    @Name("Кнопка 'Выбрать все'")
    @FindBy(xpath = ".//label[contains(@class,'check-button')]//input")
    private WebElement editAllButton;

    @Name("Чекбокс 'Показы'")
    @FindBy(xpath = ".//input[@value='shows']")
    private CheckBoxBEM shows;

    @Name("Чекбокс 'Клики'")
    @FindBy(xpath = ".//input[@value='clicks']")
    private CheckBoxBEM clicks;

    @Name("Чекбокс 'CTR'")
    @FindBy(xpath = ".//input[@value='ctr']")
    private CheckBoxBEM ctr;

    @Name("Чекбокс 'Расход всего'")
    @FindBy(xpath = ".//input[@value='sum']")
    private CheckBoxBEM sum;

    @Name("Чекбокс 'Ср. цена клика'")
    @FindBy(xpath = ".//input[@value='av_sum']")
    private CheckBoxBEM averageSum;

    @Name("Чекбокс 'Ср. позиция показа'")
    @FindBy(xpath = ".//input[@value='fp_shows_avg_pos']")
    private CheckBoxBEM averageShowsPosition;

    @Name("Чекбокс 'Ср. позиция клика'")
    @FindBy(xpath = ".//input[@value='fp_clicks_avg_pos']")
    private CheckBoxBEM averageClickPosition;

    @Name("Чекбокс 'Отказы'")
    @FindBy(xpath = ".//input[@value='bounce_ratio']")
    private CheckBoxBEM bounceRatio;

    @Name("Чекбокс 'Глубина'")
    @FindBy(xpath = ".//input[@value='adepth']")
    private CheckBoxBEM depth;

    @Name("Чекбокс 'Конверсия'")
    @FindBy(xpath = ".//input[@value='aconv']")
    private CheckBoxBEM conversion;

    @Name("Чекбокс 'Цена цели'")
    @FindBy(xpath = ".//input[@value='agoalcost']")
    private CheckBoxBEM goalCost;

    @Name("Чекбокс 'Конверсии'")
    @FindBy(xpath = ".//input[@value='agoalnum']")
    private CheckBoxBEM conversionsNum;

    @Name("Чекбокс 'Рентабельность'")
    @FindBy(xpath = ".//input[@value='agoalroi']")
    private CheckBoxBEM goalRoi;

    @Name("Чекбокс 'Доход'")
    @FindBy(xpath = ".//input[@value='agoalincome']")
    private CheckBoxBEM income;

    @Name("Чекбокс 'Прибыль'")
    @FindBy(xpath = ".//input[@value='agoals_profit']")
    private CheckBoxBEM agoalsProfit;

    public void fillShows(Boolean value) {
        if (value == null)
            setCheckboxState(shows, false);
        setCheckboxState(shows, value);
    }

    public void fillClicks(Boolean value) {
        if (value == null)
            setCheckboxState(clicks, false);
        setCheckboxState(clicks, value);
    }

    public void fillCtr(Boolean value) {
        if (value == null)
            setCheckboxState(ctr, false);
        setCheckboxState(ctr, value);
    }

    public void fillSum(Boolean value) {
        if (value == null)
            setCheckboxState(sum, false);
        setCheckboxState(sum, value);
    }

    public void fillAverageSum(Boolean value) {
        if (value == null)
            setCheckboxState(averageSum, false);
        setCheckboxState(averageSum, value);
    }

    public void fillAverageShowsPosition(Boolean value) {
        if (value == null)
            setCheckboxState(averageShowsPosition, false);
        setCheckboxState(averageShowsPosition, value);
    }

    public void fillAverageClickPosition(Boolean value) {
        if (value == null)
            setCheckboxState(averageClickPosition, false);
        setCheckboxState(averageClickPosition, value);
    }

    public void fillBounceRatio(Boolean value) {
        if (value == null)
            setCheckboxState(bounceRatio, false);
        setCheckboxState(bounceRatio, value);
    }

    public void fillDepth(Boolean value) {
        if (value == null)
            setCheckboxState(depth, false);
        setCheckboxState(depth, value);
    }

    public void fillConversion(Boolean value) {
        if (value == null)
            setCheckboxState(conversion, false);
        setCheckboxState(conversion, value);
    }

    public void fillGoalCost(Boolean value) {
        if (value == null)
            setCheckboxState(goalCost, false);
        setCheckboxState(goalCost, value);
    }

    public void fillConversionsNum(Boolean value) {
        if (value == null)
            setCheckboxState(conversionsNum, false);
        setCheckboxState(conversionsNum, value);
    }

    public void fillGoalRoi(Boolean value) {
        if (value == null)
            setCheckboxState(goalRoi, false);
        setCheckboxState(goalRoi, value);
    }

    public void fillIncome(Boolean value) {
        if (value == null)
            setCheckboxState(income, false);
        setCheckboxState(income, value);
    }

    public void fillAgoalsProfit(Boolean value) {
        if (value == null)
            setCheckboxState(agoalsProfit, false);
        setCheckboxState(agoalsProfit, value);
    }
}
