package ru.yandex.autotests.direct.web.pages.statistic.blocks;

import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.webelements.bem.CheckBoxBEM;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.HtmlElement;

import static ru.yandex.autotests.direct.web.util.WebElementsActions.setCheckboxState;

@FindBy(xpath = ".//div[contains(@class,'b-statistic-columns-slices__item_type_slices')]")
public class StatisticsReportWizardSlicesBlock extends HtmlElement {

    @Name("Чекбокс 'Метки'")
    @FindBy(xpath = ".//input[@value='tags']")
    private CheckBoxBEM tags;

    @Name("Чекбокс 'Группы'")
    @FindBy(xpath = ".//input[@value='adgroup']")
    private CheckBoxBEM adgroup;

    @Name("Чекбокс '№ Объявления'")
    @FindBy(xpath = ".//input[@value='banner']")
    private CheckBoxBEM banner;

    @Name("Чекбокс 'Тип объявления'")
    @FindBy(xpath = ".//input[@value='banner_type']")
    private CheckBoxBEM bannerType;

    @Name("Чекбокс 'Условие показа'")
    @FindBy(xpath = ".//input[@value='contextcond_orig']")
    private CheckBoxBEM contextCond;

    @Name("Чекбокс 'Условие подбора'")
    @FindBy(xpath = ".//input[@value='retargeting_coef']")
    private CheckBoxBEM retargetingCoef;

    @Name("Чекбокс 'Тип площадки'")
    @FindBy(xpath = ".//input[@value='targettype']")
    private CheckBoxBEM targetType;

    @Name("Чекбокс 'Название площадки'")
    @FindBy(xpath = ".//input[@value='page_group']")
    private CheckBoxBEM pageGroup;

    @Name("Чекбокс 'Название площадки (подробно)'")
    @FindBy(xpath = ".//input[@value='page']")
    private CheckBoxBEM page;

    @Name("Чекбокс 'Внешние сети'")
    @FindBy(xpath = ".//input[@value='ssp']")
    private CheckBoxBEM ssp;

    @Name("Чекбокс 'Регион таргетинга'")
    @FindBy(xpath = ".//input[@value='region']")
    private CheckBoxBEM region;

    @Name("Чекбокс 'Регион местонахождения'")
    @FindBy(xpath = ".//input[@value='physical_region']")
    private CheckBoxBEM physicalRegion;

    @Name("Чекбокс 'Позиция'")
    @FindBy(xpath = ".//input[@value='position']")
    private CheckBoxBEM position;

    @Name("Чекбокс 'Место клика'")
    @FindBy(xpath = ".//input[@value='click_place']")
    private CheckBoxBEM clickPlace;

    @Name("Чекбокс 'Изображения'")
    @FindBy(xpath = ".//input[@value='banner_image_type']")
    private CheckBoxBEM bannerImageType;

    @Name("Чекбокс 'Размер изображения'")
    @FindBy(xpath = ".//input[@value='image_size']")
    private CheckBoxBEM imageSize;

    @Name("Чекбокс 'Тип устройства'")
    @FindBy(xpath = ".//input[@value='device_type']")
    private CheckBoxBEM deviceType;

    @Name("Чекбокс 'Пол'")
    @FindBy(xpath = ".//input[@value='gender']")
    private CheckBoxBEM gender;

    @Name("Чекбокс 'Возраст'")
    @FindBy(xpath = ".//input[@value='age']")
    private CheckBoxBEM age;

    public void fillTags(Boolean value) {
        if (value == null)
            setCheckboxState(tags, false);
        setCheckboxState(tags, value);
    }

    public void fillAdgroup(Boolean value) {
        if (value == null)
            setCheckboxState(adgroup, false);
        setCheckboxState(adgroup, value);
    }

    public void fillBanner(Boolean value) {
        if (value == null)
            setCheckboxState(banner, false);
        setCheckboxState(banner, value);
    }

    public void fillBannerType(Boolean value) {
        if (value == null)
            setCheckboxState(bannerType, false);
        setCheckboxState(bannerType, value);
    }

    public void fillContextCond(Boolean value) {
        if (value == null)
            setCheckboxState(contextCond, false);
        setCheckboxState(contextCond, value);
    }

    public void fillRetargetingCoef(Boolean value) {
        if (value == null)
            setCheckboxState(retargetingCoef, false);
        setCheckboxState(retargetingCoef, value);
    }

    public void fillTargetType(Boolean value) {
        if (value == null)
            setCheckboxState(targetType, false);
        setCheckboxState(targetType, value);
    }

    public void fillPageGroup(Boolean value) {
        if (value == null)
            setCheckboxState(pageGroup, false);
        setCheckboxState(pageGroup, value);
    }

    public void fillPage(Boolean value) {
        if (value == null)
            setCheckboxState(page, false);
        setCheckboxState(page, value);
    }

    public void fillSsp(Boolean value) {
        if (value == null)
            setCheckboxState(ssp, false);
        setCheckboxState(ssp, value);
    }

    public void fillRegion(Boolean value) {
        if (value == null)
            setCheckboxState(region, false);
        setCheckboxState(region, value);
    }

    public void fillPhysicalRegion(Boolean value) {
        if (value == null)
            setCheckboxState(physicalRegion, false);
        setCheckboxState(physicalRegion, value);
    }

    public void fillPosition(Boolean value) {
        if (value == null)
            setCheckboxState(position, false);
        setCheckboxState(position, value);
    }

    public void fillClickPlace(Boolean value) {
        if (value == null)
            setCheckboxState(clickPlace, false);
        setCheckboxState(clickPlace, value);
    }

    public void fillBannerImageType(Boolean value) {
        if (value == null)
            setCheckboxState(bannerImageType, false);
        setCheckboxState(bannerImageType, value);
    }

    public void fillImageSize(Boolean value) {
        if (value == null)
            setCheckboxState(imageSize, false);
        setCheckboxState(imageSize, value);
    }

    public void fillDeviceType(Boolean value) {
        if (value == null)
            setCheckboxState(deviceType, false);
        setCheckboxState(deviceType, value);
    }

    public void fillGender(Boolean value) {
        if (value == null)
            setCheckboxState(gender, false);
        setCheckboxState(gender, value);
    }

    public void fillAge(Boolean value) {
        if (value == null)
            setCheckboxState(age, false);
        setCheckboxState(age, value);
    }
}
