package ru.yandex.autotests.direct.web.pages.statistic.chart;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.data.statistic.ChartType;
import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.autotests.direct.web.pages.statistic.chart.blocks.MultiSelectBlock;
import ru.yandex.autotests.direct.web.webelements.bem.RadioBEM;
import ru.yandex.autotests.irt.testutils.allure.AllureUtils;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.matchers.WebElementMatchers;

import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.direct.web.steps.CommonSteps.waitForElement;

@FindBy(css = ".b-charts-manager")
public class StatisticChart extends ExtendedHtmlElement {

    @Name("Переключатель тип графика")
    @FindBy(css = ".b-chart-filter-control input")
    private RadioBEM chartType;

    @Name("Селект 'Столбец'")
    @FindBy(css = ".b-chart-filters__columns button")
    MultiSelectBlock columnsSelect;

    @Name("Селект 'Срез'")
    @FindBy(css = ".b-chart-filters__groupBy button")
    MultiSelectBlock slicesSelect;

    @Name("Спиннер загрузки графика")
    @FindBy(css = ".spin2")
    private WebElement chartSpinner;

    @Step("Выставляем тип графика {0}")
    public void selectChartType(ChartType type) {
        chartType.selectByValue(type.getValue());
    }

    @Step("Выставляем столбцы")
    public void selectColumns(String... columns) {
        AllureUtils.addTextAttachment("столбцы", String.join(", ", columns));
        columnsSelect.selectByValues(columns);
    }

    @Step("Выставляем срезы")
    public void selectSlices(String... slices) {
        AllureUtils.addTextAttachment("срезы", String.join(", ", slices));
        slicesSelect.selectByValues(slices);
    }

    public void waitForChartLoading() {
        waitForElement(chartSpinner, 5, not(WebElementMatchers.isDisplayed()));
    }
}
