package ru.yandex.autotests.direct.web.pages.statistic.chart.blocks;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.lang3.ArrayUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.qatools.htmlelements.matchers.WebElementMatchers;

import static ru.yandex.autotests.direct.web.steps.CommonSteps.waitForElement;

public class MultiSelectBlock extends ExtendedHtmlElement {

    public void selectByValues(String... values) {
        getWrappedElement().click();
        waitForElement(getPopup(), 2, WebElementMatchers.isDisplayed());
        deselectAll();
        selectItemsByValue(values);
        getWrappedElement().click();
    }

    private void selectItemsByValue(String... values) {
        getPopup().findElements(By.xpath(".//div[contains(@class, 'b-chooser__item')]"))
                .stream()
                .filter(x -> ArrayUtils.contains(values, getValue(x)))
                .forEach(x -> x.click());
    }

    private void deselectAll() {
        getPopup().findElement(By.cssSelector(".b-chooser__unselect-all")).click();
    }

    private WebElement getPopup() {
        return getWrappedElement().findElement(
                By.xpath("//div[contains(@class, 'popup2')][contains(@class, 'popup2_visible_yes')]"));
    }

    private String getValue(WebElement element) {
        Pattern pattern = Pattern.compile("value\":\"([^\"]+)\"");
        Matcher matcher = pattern.matcher(element.getAttribute("data-bem"));
        matcher.find();
        return matcher.group(1);
    }
}
