package ru.yandex.autotests.direct.web.pages.superpages;

import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.directapi.model.User;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrl;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrls;
import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;
import ru.yandex.qatools.allure.webdriver.steps.AlertSteps;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.TextInput;

/**
 * Created by buhter on 05.12.13.
 */

@NamedUrls({
        @NamedUrl(name = "add.agency.client.relation.page",
                url = "/registered/main.pl?cmd=addAgencyClientRelation&ulogin={1}")
})
public class AddAgencyClientRelationPage extends BasePageObject {


    @Name("Инпут логина клиента")
    @FindBy(xpath = ".//input[@name='client_login']")
    private TextInput clientLoginInput;

    @Name("Кнопка добавления")
    @FindBy(xpath = ".//input[@name='do_add']")
    private Button clientLoginSubmit;

    @Name("Кнопка добавления")
    @FindBy(xpath = ".//input[@name='do_check']")
    private Button clientLoginCheck;

    @Name("Кнопка продолжить")
    @FindBy(xpath = ".//button[@type='submit' and not(contains(@class, 'p-common-error__cancel'))]")
    private Button continueButton;

    private Button getContinueButton() {
        return continueButton;
    }

    private TextInput getClientLoginInput() {
        return clientLoginInput;
    }

    private Button getClientLoginSubmit() {
        return clientLoginSubmit;
    }

    private Button getClientLoginCheck() {
        return clientLoginCheck;
    }

    public void addClientToAgency(User client) {
        getContinueButton().click();
        getClientLoginInput().clear();
        getClientLoginInput().sendKeys(client.getLogin());
        getClientLoginCheck().click();
        getClientLoginSubmit().click();
        AlertSteps.getInstance(AlertSteps.class, config).accept();
    }
}
