package ru.yandex.autotests.direct.web.pages.superpages;

import java.util.List;
import java.util.concurrent.TimeUnit;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrl;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrls;
import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;
import ru.yandex.qatools.htmlelements.annotations.Name;

import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.direct.web.util.OperationSystemUtils.sleep;
import static ru.yandex.qatools.htmlelements.matchers.WebElementMatchers.isDisplayed;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
@NamedUrls({
        @NamedUrl(name = "open.client_nds_schedule",
                url = "/registered/main.pl?cmd=internalReports&report_id=client_nds_schedule&ir_param_client_login={1}")
})
public class IinternalReportsPage extends BasePageObject {


    @Name("Таблица со значениями НДС")
    @FindBy(xpath = ".//table[contains(@class, 'campaign')]//tr/td")
    private List<WebElement> VATTableCells;

    @Name("Таблица со значениями НДС")
    @FindBy(xpath = ".//input[@type = 'submit']")
    private WebElement showButton;

    private WebElement getVATElement(String value) {
        showButton.click();
        for (WebElement cell : VATTableCells) {
            if (cell.getText().contains(value)) {
                return cell;
            }
        }
        return null;
    }

    public void checkVATValue(String value) {
        WebElement vatElement = null;
        for (int i = 0; i < 30; i++) {
            sleep(TimeUnit.SECONDS.toMillis(DirectTestRunProperties.getInstance().getDirectWebWebdriverImplicityWaitTimeoutSec()));
            vatElement = getVATElement(value);
            if (vatElement != null) {
                break;
            }
        }

        assertThat("не найдено значение " + value + " в таблице НДС", vatElement, isDisplayed());
    }
}
