package ru.yandex.autotests.direct.web.pages.superpages;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.utils.matchers.BeanEquals;
import ru.yandex.autotests.direct.web.objects.AccountWeb;
import ru.yandex.autotests.direct.web.objects.campaigns.CampaignInfoWeb;
import ru.yandex.autotests.direct.web.pages.superpages.blocks.SearchCampaignTable;
import ru.yandex.autotests.direct.web.pages.superpages.blocks.SearchClientsAndAgenciesTable;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrl;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrls;
import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.TextInput;

import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillTextInput;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */

@NamedUrls({
        @NamedUrl(name = "show.search.page", url = "/registered/main.pl?cmd=showSearchPage")
})
public class ShowSearchPage extends BasePageObject {

    private SearchClientsAndAgenciesTable searchClientsAndAgenciesTable;
    private SearchCampaignTable searchCampaignTable;

    @Name("Поле ввода для поиска клиента по логину")
    @FindBy(xpath = ".//input[@name='listbylogin']")
    private TextInput loginInput;

    @Name("Поле ввода для поиска кампании по номеру")
    @FindBy(xpath = ".//input[@name='searchcid']")
    private TextInput campaignIDInput;

    @Name("Кнопка поиска клиентов и агентств")
    @FindBy(xpath = ".//div[contains(@class, 'p-search__clients-form')]//button[@type='submit']")
    private Button searchClientsAndAgenciesButton;

    @Name("Кнопка поиска кампаний")
    @FindBy(xpath = ".//div[contains(@class, 'p-search__campaigns-form')]//button[@type='submit']")
    private Button searchCampaignsButton;

    @Name("Таблица с результатами поиска")
    @FindBy(xpath=".//div[@class='p-banners-search__found']/table")
    private WebElement searchBannersTable;

    public void fillLoginInput(String login) {
        fillTextInput(loginInput, login);
    }

    public void fillCampaignIDInput(String campaignID) {
        fillTextInput(campaignIDInput, campaignID);
    }

    public void clickOnSearchClientsAndAgenciesButton() {
        searchClientsAndAgenciesButton.click();
    }

    public void clickOnSearchCampaignsButton() {
        searchCampaignsButton.click();
    }

    public void checkSearchAccount(BeanEquals<AccountWeb> matcher) {
        searchClientsAndAgenciesTable.checkSearchAccount(matcher);
    }

    public void checkSearchCampaign(BeanEquals<CampaignInfoWeb> matcher) {
        searchCampaignTable.checkSearchCampaignRow(matcher);
    }

    public WebElement getSearchBannersTable() {
        return searchBannersTable;
    }
}
