package ru.yandex.autotests.direct.web.pages.superpages.blocks;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.utils.matchers.BeanEquals;
import ru.yandex.autotests.direct.web.objects.AccountWeb;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.Link;

import static ch.lambdaj.Lambda.on;
import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.direct.web.util.beanutils.BeanFieldsSetter.inAccordanceWith;

/**
 * @author : Alex Samokhin (alex-samo@yandex-team.ru)
 *         Date: 13.02.14
 */

@Name("Строка в таблице поиска агентств")
@FindBy(xpath = ".//tr[contains(@class, 'b-data-table__row')]")
public class SearchAgencyRow extends HtmlElement {

    @Name("Логин")
    @FindBy(xpath = ".//td[2]/a")
    private Link login;

    @Name("Название агентства")
    @FindBy(xpath = ".//td[3]")
    private WebElement name;

    @Name("Менеджер ангентсва")
    @FindBy(xpath = ".//td[4]/a")
    private Link manager;

    public String getLogin() {
        return login.getText();
    }

    public void checkAgencyParameters(BeanEquals<AccountWeb> matcher) {
        assertThat("неверные параметры агентства ", getAgencyFormFieldsAccording(matcher.getExpectedBean()),
                matcher);
    }

    public AccountWeb getAgencyFormFieldsAccording(AccountWeb expectedBean) {
        AccountWeb accountWeb = inAccordanceWith(expectedBean).forNew(AccountWeb.class)
                .set("login", login, on(Link.class).getText())
                .set("name", name, on(WebElement.class).getText())
                .set("manager", manager, on(Link.class).getText())
                .getActualBean();
        accountWeb.setRole(expectedBean.getRole());
        return accountWeb;
    }
}
