package ru.yandex.autotests.direct.web.pages.superpages.blocks;

import java.util.regex.Pattern;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.utils.matchers.BeanEquals;
import ru.yandex.autotests.direct.web.objects.campaigns.CampaignInfoWeb;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.HtmlElement;

import static ch.lambdaj.Lambda.on;
import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.direct.web.util.beanutils.BeanFieldsSetter.inAccordanceWith;

/**
 * @author : Alex Samokhin (alex-samo@yandex-team.ru)
 *         Date: 13.02.14
 */

@Name("Строка в таблице поиска кампаний")
@FindBy(xpath = ".//tr[contains(@class, 'b-campaigns-list-item')]")
public class SearchCampaignRow extends HtmlElement {

    @Name("Назнвание и номер кампании")
    @FindBy(xpath = ".//td[2]/h3")
    private WebElement campaignNameAndID;


    public String getCampaignID() {
        Pattern pattern = Pattern.compile("№ (\\d+)");
        java.util.regex.Matcher matcher = pattern.matcher(campaignNameAndID.getText());
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public void checkCampaignParameters(BeanEquals<CampaignInfoWeb> matcher) {
        assertThat("неверные параметры кампании", getCampaignFormFieldsAccording(matcher.getExpectedBean()),
                matcher);
    }

    public CampaignInfoWeb getCampaignFormFieldsAccording(CampaignInfoWeb expectedBean) {
        CampaignInfoWeb accountWeb = inAccordanceWith(expectedBean).forNew(CampaignInfoWeb.class)
                .set("campaignId", this, on(SearchCampaignRow.class).getCampaignID())
                .getActualBean();
        return accountWeb;
    }
}
