package ru.yandex.autotests.direct.web.pages.superpages.blocks;

import java.util.List;

import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.utils.matchers.BeanEquals;
import ru.yandex.autotests.direct.web.objects.campaigns.CampaignInfoWeb;
import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.HtmlElement;

/**
 * @author : Alex Samokhin (alex-samo@yandex-team.ru)
 *         Date: 13.02.14
 */

@Name("Таблица с результатами поиска кампаний")
@FindBy(xpath = ".//table[contains(@class, 'b-campaigns-list__table')]")
public class SearchCampaignTable extends HtmlElement {

    private List<SearchCampaignRow> searchCampaignRows;

    private SearchCampaignRow getSearchCampaignsRow(String campaignID) {
        for (SearchCampaignRow searchCampaign : searchCampaignRows) {
            if (searchCampaign.getCampaignID().equalsIgnoreCase(campaignID)) {
                return searchCampaign;
            }
        }
        return null;
    }

    public void checkSearchCampaignRow(BeanEquals<CampaignInfoWeb> matcher) {
        SearchCampaignRow searchCampaignsRow = getSearchCampaignsRow(
                String.valueOf(matcher.getExpectedBean().getCampaignId()));
        if (searchCampaignsRow == null) {
            throw new DirectWebError("Не найдена кампания: " + String.valueOf(matcher.getExpectedBean().getCampaignId()));
        } else {
            searchCampaignsRow.checkCampaignParameters(matcher);
        }
    }
}
