package ru.yandex.autotests.direct.web.pages.superpages.blocks;

import java.util.List;

import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.utils.matchers.BeanEquals;
import ru.yandex.autotests.direct.web.objects.AccountWeb;
import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.HtmlElement;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
@Name("Таблица с результатами поиска клиентов/агентств")
@FindBy(xpath = ".//table[contains(@class, 'b-data-table')]")
public class SearchClientsAndAgenciesTable extends HtmlElement {

    private List<SearchClientsRow> searchClientsRows;
    private List<SearchAgencyRow> searchAgencyRows;

    private SearchClientsRow getSearchClientsRow(String login) {
        for (SearchClientsRow searchClient : searchClientsRows) {
            if (searchClient.getLogin().equalsIgnoreCase(login)) {
                return searchClient;
            }
        }
        return null;
    }

    private void checkSearchAgencyRow(BeanEquals<AccountWeb> matcher) {
        SearchAgencyRow searchAgencyRow = getSearchAgencyRow(matcher.getExpectedBean().getLogin());
        if (searchAgencyRow == null) {
            throw new DirectWebError("Не найдено агентство: " + matcher.getExpectedBean().getLogin());
        } else {
            searchAgencyRow.checkAgencyParameters(matcher);
        }
    }

    private SearchAgencyRow getSearchAgencyRow(String login) {
        for (SearchAgencyRow searchAgencyRow : searchAgencyRows) {
            if (searchAgencyRow.getLogin().equalsIgnoreCase(login)) {
                return searchAgencyRow;
            }
        }
        return null;
    }

    private void checkSearchClientRow(BeanEquals<AccountWeb> matcher) {
        SearchClientsRow searchClientsRow = getSearchClientsRow(matcher.getExpectedBean().getLogin());
        if (searchClientsRow == null) {
            throw new DirectWebError("Не найден клиент: " + matcher.getExpectedBean().getLogin());
        } else {
            searchClientsRow.checkClientParameters(matcher);
        }
    }

    public void checkSearchAccount(BeanEquals<AccountWeb> matcher) {
        switch (matcher.getExpectedBean().getRole()) {
            case CLIENT:
            case SUBCLIENT:
            default:
                checkSearchClientRow(matcher);
                break;
            case AGENCY:
                checkSearchAgencyRow(matcher);
                break;
        }
    }
}