package ru.yandex.autotests.direct.web.pages.superpages.optimizecampaigns;

import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.objects.campaigns.HelpRequestInfo;
import ru.yandex.autotests.direct.web.util.testinterfaces.IWebFrom;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.Link;
import ru.yandex.qatools.htmlelements.element.TextBlock;

import static ch.lambdaj.Lambda.on;
import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.direct.web.util.beanutils.BeanFieldsSetter.inAccordanceWith;
import static ru.yandex.autotests.direct.web.util.beanutils.BeanHelper.getOnlySimpleFields;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;
import static ru.yandex.autotests.irt.testutils.beandiffer2.beanfield.BeanFieldPath.newPath;

/**
 * User: xy6er
 * Date: 02.07.13
 * Time: 15:47
 */

@Name("Строка заявок на первую и вторую помощь")
@FindBy(xpath = ".//tr[contains(@class, 'tdata') and position() > 1]")
public class HelpRequestRow extends HtmlElement implements IWebFrom<HelpRequestInfo> {

    @Name("логин Клиента")
    @FindBy(xpath = ".//td[3]")
    private TextBlock clientLogin;

    @Name("ID Кампании")
    @FindBy(xpath = ".//td[5]/a")
    private Link campaignIDLink;


    public String getClientLogin() {
        return clientLogin.getText().trim().replace("\nудалить", "");
    }

    public Long getCampaignId() {
        return Long.parseLong(campaignIDLink.getText());
    }


    @Override
    public HelpRequestInfo getFormFieldsAccording(HelpRequestInfo expectedBean) {
        if (expectedBean != null) {
            return inAccordanceWith(expectedBean).forNew(HelpRequestInfo.class)
                    .set("campaignId", this, on(HelpRequestRow.class).getCampaignId())
                    .set("clientLogin", this, on(HelpRequestRow.class).getClientLogin())
                    .getActualBean();
        }
        return null;
    }

    @Override
    public void checkParameters(HelpRequestInfo expectedBean) {
        assertThat("неверные параметры заявки на помощь",
                getFormFieldsAccording(getOnlySimpleFields(expectedBean)), beanDiffer(expectedBean).useCompareStrategy(
                        DefaultCompareStrategies.onlyFields(newPath("campaignId"), newPath("clientLogin"))));
    }

    @Override
    public void fillParameters(HelpRequestInfo expectedBean) {
        throw new UnsupportedOperationException();
    }

}
