package ru.yandex.autotests.direct.web.pages.superpages.optimizecampaigns;

import java.util.List;

import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.objects.campaigns.HelpRequestInfo;
import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrl;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrls;
import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.Select;

@NamedUrls({
        @NamedUrl(name = "list.optimize.page", url = "/registered/main.pl?cmd=listOptimize")
})
public class ListOptimizePage extends BasePageObject {


    @Name("Источник заявки")
    @FindBy(xpath = ".//select[@name = 'request_type']")
    private Select requestTypeSelect;

    @Name("Кнопка Показать заявки")
    @FindBy(xpath = ".//div[@class = 'buttons']/input[@type = 'submit']")
    private Button showRequestsButton;

    @Name("Список заявок")
    private List<HelpRequestRow> optimizeCampaignsRowList;

    private HelpRequestRow getHelpRequestRow(Long campaigId) {
        return optimizeCampaignsRowList.stream().filter(row -> row.getCampaignId().equals(campaigId))
                .findFirst()
                .orElseThrow(() -> new DirectWebError("Не удалось найти заявку кампании " + campaigId));
    }

    public void checkHelpRequestParameters(HelpRequestInfo expectedBean) {
        getHelpRequestRow(expectedBean.getCampaignId()).checkParameters(expectedBean);
    }
}
