package ru.yandex.autotests.direct.web.pages.transfer;

import org.hamcrest.Matcher;
import org.openqa.selenium.support.FindBy;
import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Link;

import java.util.List;

/**
 * User: buhter
 * Date: 10.12.12
 * Time: 20:16
 */
public class TransferFormTable extends ExtendedHtmlElement {

    @Name("Ссылка 'Перенести все'")
    @FindBy(css = "span.p-transfer-between-campaigns__select-all-link")
    private Link transferAllLink;

    @Name("Ссылка 'Очистить все'")
    @FindBy(css = "span.p-transfer-between-campaigns__clear-all-link")
    private Link clearLink;

    public List<TransferFormTableRow> tableRows;

    public TransferFormTableRow getTransferFormTableRow(Long campaignId) {
        for (TransferFormTableRow transferFormTableFromRow : tableRows) {
            if (transferFormTableFromRow.rowCampaignIdContains(campaignId.toString())) {
                transferFormTableFromRow.setConfig(config);
                return transferFormTableFromRow;
            }
        }
        throw new DirectWebError("В таблице выбора кампаний для переноса средств не найдено кампании с ID " + campaignId);
    }

    public void checkAvailableTransferMoney(Long campaignToId, Matcher<String> matcher) {
        getTransferFormTableRow(campaignToId).checkAvailableTransferMoney(matcher);
    }

    public String getAvailableTransferMoney(Long campaignToId) {
        return getTransferFormTableRow(campaignToId).getAvailableTransferMoney();
    }

    public void transferAll() {
        transferAllLink.click();
    }

    public void clearAll() {
        clearLink.click();
    }
}