package ru.yandex.autotests.direct.web.pages.transfer;

import org.hamcrest.Matcher;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.autotests.direct.web.util.JavaScriptActions;
import ru.yandex.autotests.direct.web.util.WebElementsActions;
import ru.yandex.autotests.direct.web.webelements.NumericInput;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.TextInput;

import static org.hamcrest.MatcherAssert.assertThat;

@Name("Ряд кампании в таблице с кампаниями с которых переносятся средства")
@FindBy(css = "tr.p-transfer-between-campaigns__campaign")
public class TransferFormTableRow extends ExtendedHtmlElement {

    @Name("Доступные для переноса средства")
    @FindBy(css = "div.p-transfer-between-campaigns__campaigns-table-list-txt_td_available")
    private WebElement availableTransferMoney;

    @Name("Поле ввода суммы для переноса")
    @FindBy(css = "input.p-transfer-campaign__input-control")
    private TextInput campaignSumAmountInput;

    @Name("Номер кампании")
    @FindBy(css = "div.p-transfer-between-campaigns__campaign-cid")
    private WebElement campaignID;

    public void selectCampaign() {
        this.click();
    }

    public void fillSumAmountInput(String value) {
        campaignSumAmountInput.sendKeys(value);
        campaignID.click();
    }

    public String getSumAmountValue() {
        return this.campaignSumAmountInput.getText();
    }

    public boolean rowCampaignIdContains(String campaingId) {
        return campaignID.getText().contains(campaingId);
    }

    public void checkAvailableTransferMoney(Matcher<String> matcher) {
        assertThat(availableTransferMoney.getAttribute("title"), matcher);
    }

    public String getAvailableTransferMoney() {
        return availableTransferMoney.getAttribute("title");
    }
}
