package ru.yandex.autotests.direct.web.pages.transfer;


import java.util.concurrent.TimeUnit;

import org.hamcrest.Matcher;

import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.direct.web.objects.transfer.TransferType;
import ru.yandex.autotests.direct.web.steps.AlertSteps;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrl;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrls;
import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;

import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.qatools.htmlelements.matchers.MatcherDecorators.should;
import static ru.yandex.qatools.htmlelements.matchers.MatcherDecorators.timeoutHasExpired;

/**
 * User: buhter
 * Date: 04.02.13
 * Time: 18:33
 * Страница переноса средств между кампаниями одного пользователя
 */
@NamedUrls({
        @NamedUrl(name = "transfer.page", url = "/registered/main.pl?cmd=transfer"),
        @NamedUrl(name = "clients.transfer.page", url = "/registered/main.pl?cmd=transfer&ulogin={1}")
})
public class TransferPage extends BasePageObject {
    private TransferForm transferForm;

    private AlertSteps alert() {
        return AlertSteps.getInstance(AlertSteps.class, config);
    }

    private TransferTypeSelector transferFormSelector;

    public void acceptAlert(Matcher<String> matcher) {
        alert().accept(matcher);
    }

    public TransferForm onTransferForm() {
        transferForm.setConfig(config);
        return transferForm;
    }

    public void chooseTransferType(TransferType type) {
        transferFormSelector.chooseTransferType(type.getValue());
        onTransferForm().selectTransferType(type);
    }

    public void checkTransferError(Matcher matcher) {
        assertThat("ошибка переноса не соответствует ожиданиям",
                transferFormSelector.getTransferErrorText(), should(matcher).
                        whileWaitingUntil(timeoutHasExpired(TimeUnit.SECONDS.toMillis(
                                DirectTestRunProperties.getInstance().getDirectWebWebdriverImplicityWaitTimeoutSec()))));
    }

}
