package ru.yandex.autotests.direct.web.pages.transfer;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.data.RadioInputMethod;
import ru.yandex.autotests.direct.web.webelements.bem.RadioBEM;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.HtmlElement;

import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillRadio;

/**
 * User: buhter
 * Date: 11.12.12
 * Time: 18:04
 */
@Name("Группа радиокнопок выбора типа переноса")
@FindBy(css = "div.p-transfer-between-campaigns__header")
public class TransferTypeSelector extends HtmlElement {

    @Name("Радиобаттон выбора типа переноса")
    @FindBy(xpath = ".//input[@value='single']")
    private RadioBEM transferTypeRadioButton;

    @Name("Ошибка при переносе средств")
    @FindBy(css = "div.p-transfer-between-campaigns__error")
    private WebElement transferError;

    public void chooseTransferType(String value) {
        fillRadio(transferTypeRadioButton, value, RadioInputMethod.BY_VALUE);
    }

    public String getTransferErrorText() {
        return transferError.getText();
    }
}
