package ru.yandex.autotests.direct.web.pages.users;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.autotests.direct.web.webelements.bem.FileInputBEM;
import ru.yandex.autotests.direct.web.webelements.bem.TextAreaBEM;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrl;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrls;
import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.TextInput;

import static ru.yandex.autotests.direct.web.steps.CommonSteps.waitForElement;
import static ru.yandex.qatools.htmlelements.matchers.WebElementMatchers.isDisplayed;


@Name("Страница загрузки документов для модерации")
@NamedUrls({
        @NamedUrl(name = "load.documents", url = "/registered/main.pl?cmd=showUploadModerationDocs&ulogin={1}")
})
public class UserUploadDocumentsPage extends BasePageObject {

    @Name("Кнопка сохранить")
    @FindBy(css = "button.p-upload-subclient-docs__submit")
    protected Button saveButton;

    @Name("E-mail")
    @FindBy(css = "input.p-upload-subclient-docs__email-control")
    private TextInput email;

    @Name("Номер кампании")
    @FindBy(xpath = ".//input[@name='campaign_name']")
    private TextInput campaignId;

    @Name("Комментарий")
    @FindBy(css = "textarea.p-upload-subclient-docs__comment-control")
    private TextAreaBEM comment;

    @Name("Поле ввода файла для загрузки")
    @FindBy(xpath = ".//input[@type='file']")
    private FileInputBEM uploadFileInput;

    @Name("Сообщение об успехе загрузки")
    @FindBy(xpath = ".//div[contains(@class, 'p-upload-subclient-docs__docs-uploaded-info')]/div")
    private WebElement uploadMessage;

    @Name("Загруженный файл")
    @FindBy(xpath = ".//span[contains(@class, 'p-upload-subclient-docs__attach_state_file-choosen')]//label")
    private WebElement attachFile;

    public void setEmail(String emailText) {
        email.sendKeys(emailText);
    }

    public void setCampaignId(String campaignIdText) {
        campaignId.sendKeys(campaignIdText);
    }

    public void setComment(String commentText) {
        comment.sendKeys(commentText);
    }

    public void clickSend() {
        saveButton.click();
    }

    public void uploadFile(String fileName) {
        uploadFileInput.setFileToUpload(fileName);
        takeScreenshot();
        waitForElement(attachFile, 3, isDisplayed());
        if (!fileName.contains(getAttachFileName())) {
            throw new DirectWebError("на странице не найден файл: " + fileName);
        }
    }

    public String getUploadMessage() {
        return uploadMessage.getText();
    }

    private String getAttachFileName() {
        return attachFile.getText();
    }
}