package ru.yandex.autotests.direct.web.pages.users.blocks;

import org.openqa.selenium.support.FindBy;

import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.TextInput;

import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillTextInput;

/**
 * @author : Alex Samokhin (alex-samo@yandex-team.ru)
 *         Date: 06.08.14
 */

@Name("Попап добавления email")
@FindBy(xpath = ".//div[contains(@class, 'b-user-settings__email-add-new-popup ')]")
public class AddEmailPopupBlock extends HtmlElement {

    @Name("Новый E-mail")
    @FindBy(xpath = ".//input[@name='newemail']")
    private TextInput newEmailTextInput;

    @Name("Сохранить")
    @FindBy(xpath = ".//button[contains(@class, 'b-user-settings-add-email__accept')]")
    private Button saveButton;

    public void fillEmailTextInput(String email) {
        fillTextInput(newEmailTextInput, email);
    }

    public void clickOnSaveButton() {
        saveButton.click();
    }
}
