package ru.yandex.autotests.direct.web.steps;

import java.util.List;

import ru.yandex.autotests.direct.cmd.data.CMD;
import ru.yandex.autotests.direct.cmd.data.showcampstat.reportwizard.SearchQueriesWithFiltersStatRequest;
import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.direct.web.data.CampaignTypeEnum;
import ru.yandex.autotests.direct.web.data.ExcelPageTabEnum;
import ru.yandex.autotests.direct.web.data.banners.BannerStatesEnum;
import ru.yandex.autotests.direct.web.helpers.UrlBuilderHelper;
import ru.yandex.autotests.direct.web.pages.YandexAgenciesPromoPage;
import ru.yandex.autotests.direct.web.pages.account.ClientWalletPage;
import ru.yandex.autotests.direct.web.pages.agencies.AgSearchPage;
import ru.yandex.autotests.direct.web.pages.api.APISettingsPage;
import ru.yandex.autotests.direct.web.pages.api.APISmsAuthPage;
import ru.yandex.autotests.direct.web.pages.autopayment.AutoPaymentPage;
import ru.yandex.autotests.direct.web.pages.banners.AddAdGroupsDynamicPage;
import ru.yandex.autotests.direct.web.pages.banners.AddAdGroupsMcBannerPage;
import ru.yandex.autotests.direct.web.pages.banners.AddAdGroupsMobileContentPage;
import ru.yandex.autotests.direct.web.pages.banners.AddAdGroupsPerformancePage;
import ru.yandex.autotests.direct.web.pages.banners.AddBannerMultiEditPage;
import ru.yandex.autotests.direct.web.pages.banners.EditGroupsCpmPage;
import ru.yandex.autotests.direct.web.pages.banners.SearchBannersPage;
import ru.yandex.autotests.direct.web.pages.campaigns.EditCampPage;
import ru.yandex.autotests.direct.web.pages.campaigns.OrderCampaignOptimizingPage;
import ru.yandex.autotests.direct.web.pages.campaigns.ShowCampsPage;
import ru.yandex.autotests.direct.web.pages.campaigns.ShowContactInfoPage;
import ru.yandex.autotests.direct.web.pages.campaigns.ShowMediaplanPage;
import ru.yandex.autotests.direct.web.pages.campaigns.ShowSubClientCampsPage;
import ru.yandex.autotests.direct.web.pages.clients.ShowClientsPage;
import ru.yandex.autotests.direct.web.pages.clients.ShowManagerMyClientsPage;
import ru.yandex.autotests.direct.web.pages.clients.WelcomePage;
import ru.yandex.autotests.direct.web.pages.dna.filters.logger.DnaLoggerFilter;
import ru.yandex.autotests.direct.web.pages.dna.pages.showcamps.DnaShowCampsPage;
import ru.yandex.autotests.direct.web.pages.excel.ShowExportedXlsListPage;
import ru.yandex.autotests.direct.web.pages.feeds.ShowFeedsPage;
import ru.yandex.autotests.direct.web.pages.managers.AdmShowAddAgencyPage;
import ru.yandex.autotests.direct.web.pages.managers.CopyCampPage;
import ru.yandex.autotests.direct.web.pages.payment.PaymentPage;
import ru.yandex.autotests.direct.web.pages.representatives.agency.AddAgRepPage;
import ru.yandex.autotests.direct.web.pages.representatives.agency.AdminPageAgPage;
import ru.yandex.autotests.direct.web.pages.representatives.agency.DeleteAgRepPage;
import ru.yandex.autotests.direct.web.pages.representatives.agency.ManageClientsOfAgencyPage;
import ru.yandex.autotests.direct.web.pages.representatives.agency.ShowAgRepsPage;
import ru.yandex.autotests.direct.web.pages.representatives.client.AddClRepPage;
import ru.yandex.autotests.direct.web.pages.representatives.client.DeleteClRepPage;
import ru.yandex.autotests.direct.web.pages.representatives.client.ShowClRepsPage;
import ru.yandex.autotests.direct.web.pages.retargeting.ShowRetargetingCondPage;
import ru.yandex.autotests.direct.web.pages.showcampbem.ShowCampPage;
import ru.yandex.autotests.direct.web.pages.smartbanners.ShowCreativesPage;
import ru.yandex.autotests.direct.web.pages.statistic.ShowCampStatPage;
import ru.yandex.autotests.direct.web.pages.superpages.AddAgencyClientRelationPage;
import ru.yandex.autotests.direct.web.pages.superpages.ModifyUserPage;
import ru.yandex.autotests.direct.web.pages.superpages.ShowSearchPage;
import ru.yandex.autotests.direct.web.pages.superpages.optimizecampaigns.ListOptimizePage;
import ru.yandex.autotests.direct.web.pages.transfer.TransferPage;
import ru.yandex.autotests.direct.web.pages.transfer.TransferStepZeroPage;
import ru.yandex.autotests.direct.web.pages.turbolanding.TurboLandingsPage;
import ru.yandex.autotests.direct.web.pages.users.UserSettingsPage;
import ru.yandex.autotests.direct.web.pages.users.UserUploadDocumentsPage;
import ru.yandex.autotests.direct.web.steps.banners.AddBannerMultiEditPageSteps;
import ru.yandex.autotests.direct.web.steps.representatives.agency.AddAgRepPageSteps;
import ru.yandex.autotests.direct.web.util.helpers.urlparameter.ListMapper;
import ru.yandex.autotests.direct.web.util.helpers.urlparameter.UrlParameterMapper;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.irt.testutils.allure.AllureUtils;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.annotations.WithoutScreenshot;
import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;

import static com.google.common.collect.ImmutableList.of;
import static java.util.stream.Collectors.toList;
import static ru.yandex.autotests.direct.web.pages.campaigns.EditCampPage.NamedUrls.NEW_CAMP_TYPE;
import static ru.yandex.autotests.direct.web.pages.campaigns.EditCampPage.NamedUrls.NEW_CAMP_TYPE_FOR_LOGIN;
import static ru.yandex.qatools.allure.webdriver.pages.BasePageObject.withParameters;

public class AddressBarSteps extends BaseSteps {
    @Step("Открываем главную страницу директа")
    public void openDirectPage() {
        config.getDriver().get(config.getBaseUrl());
    }

    @Step("Открываем страницу добавления новой кампании")
    public void openNewCampaignParamsForm() {
        open(EditCampPage.class, "new.camp", withParameters());
    }

    @Step("Открываем страницу показа кампании {0}")
    public void openShowCampPage(Long campaignId) {
        open(ShowCampPage.class, "show.camp", withParameters(campaignId.toString()));
    }

    @Step("Открываем страницу условий ретаргетинга")
    public void openShowRetargetingCondPage() {
        open(ShowRetargetingCondPage.class, "open.show.retargeting.cond", withParameters());
    }

    @Step("Открываем страницу условий ретаргетинга для логина")
    public void openShowRetargetingCondPage(String login) {
        open(ShowRetargetingCondPage.class, "open.show.retargeting.cond.for.login", withParameters(login));
    }

    @Step("Открываем страницу показа кампании {0} для логина {1}")
    public void openShowCampPage(Long campaignID, String userLogin) {
        open(ShowCampPage.class, "show.camp.for.login",
                withParameters(campaignID.toString(), userLogin));
    }

    public void openShowCampPageFilter(BannerStatesEnum state, Long campaignId, String login) {
        open(ShowCampPage.class, "show.camp.page.filter",
                withParameters(state.getType(), campaignId.toString(), login));
    }

    @Step("Открываем страницу со всеми объявлений")
    public void openShowCampPageAll(Long campaignId, String login) {
        openShowCampPageFilter(BannerStatesEnum.ALL, campaignId, login);
    }

    @Step("Открываем страницу с активными объявлениями")
    public void openShowCampPageActive(Long campaignId, String login) {
        openShowCampPageFilter(BannerStatesEnum.ACTIVE, campaignId, login);
    }

    @Step("Открываем страницу с остановленными объявлениями")
    public void openShowCampPageOff(Long campaignId, String login) {
        openShowCampPageFilter(BannerStatesEnum.STOPPED, campaignId, login);
    }

    @Step("Открываем страницу с архивированными объявлениями")
    public void openShowCampPageArch(Long campaignId, String login) {
        openShowCampPageFilter(BannerStatesEnum.ARCHIVE, campaignId, login);
    }

    @Step("Открываем страницу всех кампаний")
    public void openShowCampsPage() {
        open(ShowCampsPage.class, "show.camps.page", withParameters());
    }

    @Step("Открываем страницу настроек пользователя")
    public void openUserSettingsPage(String login) {
        open(UserSettingsPage.class, "user.settings", withParameters(login));
    }

    @Step("Открываем страницу редактирования пользователя {0}")
    public void openModifyUserPage(String login) {
        open(ModifyUserPage.class, "modify.user.page", withParameters(login));
    }

    @Step("Открываем страницу списка заявок на первую помощь")
    public void openListOptimizePage() {
        open(ListOptimizePage.class, "list.optimize.page", withParameters());
    }

    @Step("Открываем страницу клиентов")
    public void openShowClientsPage() {
        open(ShowClientsPage.class, "show.clients.page", withParameters());
    }

    @Step("Открываем страницу редактирования кампании {0} для логина {1}")
    public void openEditCampPageForCampaign(Long campaignId, String login) {
        open(EditCampPage.class, "edit.camp.for.login",
                withParameters(campaignId.toString(), login));
    }

    public void openEditBannersGroupPage(Long campaignId, String login, Long adgroupId) {
        openEditBannersGroupPage(campaignId, login, of(adgroupId));
    }

    @Step("Открываем страницу редактирования группы баннеров {2} кампании {0} для клиента {1}")
    public void openEditBannersGroupPage(Long campaignId, String login, List<Long> adgroupIds) {
        open(AddBannerMultiEditPage.class, "edit.bannergroup.for.client",
                withParameters(campaignId.toString(), login,
                        String.join(",", adgroupIds.stream().map(x -> x.toString()).collect(toList()))));
    }

    @Step("Открываем страницу добавления новой группы в мобильной кампании {0} для клиента {1}")
    public void openAddNewMobileAppBannerToCampaignPage(Long campaignId, String login) {
        open(AddAdGroupsMobileContentPage.class, "new.banner.mobile", withParameters(campaignId.toString(), login));
    }

    @Step("Открываем страницу редактирования баннера {1} кампании {0} для клиента {2} для группы {3}")
    public void openEditBannerPage(Long campaignId, Long bannerId, String login, Long adgroupId) {
        open(AddBannerMultiEditPage.class, "edit.banner.for.client",
                withParameters(campaignId.toString(), bannerId.toString(), login, adgroupId.toString()));
    }

    @Step("Открываем страницу редактирования баннера {1} кампании {0} для группы {2}")
    public void openEditBannerPage(Long campaignId, Long bannerId, Long adgroupId) {
        open(AddBannerMultiEditPage.class, "edit.banner",
                withParameters(campaignId.toString(), bannerId.toString(), adgroupId.toString()));
    }

    @Step("Открываем страницу редактирования ДМО группы кампании {1} пользователя {2} групп: [{3}], баннеров: [{4}]")
    private void openEditPerformanceBannersGroupPage(String campaignId, String login, String adgroupIds, String bids) {
        open(AddAdGroupsPerformancePage.class, "edit.bannergroup.performance.for.client",
                withParameters(campaignId, login, adgroupIds, bids));
    }

    @Step("Открываем страницу редактирования баннера мобильных приложений {1} кампании {0} для клиента {2} для группы {3}")
    public void openEditMobileAppBannerPage(Long campaignId, Long bannerId, String login, Long adgroupId) {
        open(AddAdGroupsMobileContentPage.class, "edit.banner.mobile.for.client",
                withParameters(campaignId.toString(), bannerId.toString(), login, adgroupId.toString()));
    }

    @Step("Открываем страницу редактирования баннера {1} мобильных приложений из кампании {0} для группы {2}")
    public void openEditMobileAppBannerPage(Long campaignId, Long bannerId, Long adgroupId) {
        open(AddAdGroupsMobileContentPage.class, "edit.banner.mobile",
                withParameters(campaignId.toString(), bannerId.toString(), adgroupId.toString()));
    }

    @Step("Открываем админскую страницу агентств")
    public void openAdminPageAgPage() {
        open(AdminPageAgPage.class, "show.administration.page", withParameters());
    }

    @Step("Открываем страницу удаления представителей")
    public void openDeleteClRepPage(String representativeLogin) {
        open(DeleteClRepPage.class, "delete.representative", withParameters(representativeLogin));
    }

    @Step("Открываем страницу показа агентстких представителей")
    public void openShowAgRepsPage() {
        open(ShowAgRepsPage.class, "open.show.active.agency.representatives.page", withParameters());
    }

    @Step("Открываем страницу показа агентстких представителей для логина {0}")
    public void openShowAgRepsPage(String login) {
        open(ShowAgRepsPage.class, "open.show.active.agency.representatives.page.for.login", withParameters(login));
    }

    @Step("Открываем страницу удаления представителей для логина {0}")
    public void openDeleteAgRepPage(String representativeLogin) {
        open(DeleteAgRepPage.class, "delete.agency.representative", withParameters(representativeLogin));
    }

    @Step("Отрываем страницу добавления представителя агентству")
    public void openAddAgRepPage() {
        open(AddAgRepPage.class, "show.add.agency.representative.page", withParameters());
        getInstance(AddAgRepPageSteps.class, config).submit();
    }

    @Step("Отрываем страницу добавления представителя клиенту")
    public void openAddClRepPage() {
        open(AddClRepPage.class, "show.add.client.representative.page", withParameters());
        getInstance(AddAgRepPageSteps.class, config).submit();
    }

    @Step("Открываем страницу представителей")
    public void openShowClRepsPage() {
        open(ShowClRepsPage.class, "open.show.representatives.page", withParameters());
    }

    @Step("Открываем страницу активных представителей для логина {0}")
    public void openShowClRepsPage(String login) {
        open(ShowClRepsPage.class, "open.show.active.representatives.page.for.login", withParameters(login));
    }

    @Step("Открываем страницу клиентов агентства")
    public void openManageClientsOfAgencyPage() {
        open(ManageClientsOfAgencyPage.class, "open.manage.clients.of.agency.page", withParameters());
    }

    @Step("Октрываем страницу архивных клиентов")
    public void openShowArchivedClientsPage() {
        open(ShowClientsPage.class, "show.archieved.clients.page", withParameters());
    }

    @Step("Открываем страницу медиаплана кампании {0} для логина {1}")
    public void openShowMediaplanPage(Long campaignId, String login) {
        open(ShowMediaplanPage.class, "show.mediaplan.manager.page", withParameters(campaignId.toString(), login));
    }

    @Step("Открываем страницу медиаплана кампании {0}")
    public void openShowMediaplanPage(Long campaignId) {
        open(ShowMediaplanPage.class, "show.mediaplan.page", withParameters(campaignId.toString()));
    }

    @Step("Открываем страницу поиска")
    public void openShowSearchPage() {
        open(ShowSearchPage.class, "show.search.page", withParameters());
    }

    @Step("Открываем страницу поиска объявлений")
    public void openSearchBannersPage() {
        open(SearchBannersPage.class, "search.banners", withParameters());
    }

    @Step("Открываем страницу поиска агентских клиентов")
    public void openAgSearchPage() {
        open(AgSearchPage.class, "agency.search", withParameters());
    }

    @Step("Открываем страницу статистики кампании {0} для логина {1}")
    public void openShowCampStatPage(Long campaignId, String login) {
        open(ShowCampStatPage.class, "campaign.stat.for.login", withParameters(campaignId.toString(), login));
    }

    @Step("Открываем страницу статистики кампаний логина {0}")
    public void openShowCampStatPageForAllCampaigns(String login) {
        open(ShowCampStatPage.class, "all.campaigns.stat.for.login", withParameters(login));
    }

    @Step("Открываем страницу статистики используя запрос")
    public void openPageStatistics(SearchQueriesWithFiltersStatRequest request) {
        String url = new UrlBuilderHelper(DirectTestRunProperties.getInstance().getDirectHost())
                .getUrl(request, CMD.SHOW_STAT);
        AllureUtils.addHtmlAttachment("URL", String.format("<a href=\"%s\" target=\"_blank\">%s</a>", url, url));
        config.getDriver().get(url);
    }

    @Step("Переходим по прямой ссылке")
    @WithoutScreenshot
    protected <T extends BasePageObject> void open(Class<T> pageClass, String urlName, String[] params) {
        BasePageObject page = BasePageObject.getInstance(pageClass, config);
        String url = page.getNamedUrl(urlName, params);
        AllureUtils.addHtmlAttachment("URL", String.format("<a href=\"%s\" target=\"_blank\">%s</a>", url, url));
        page.open(urlName, params);
    }

    public void openPage(String params) {
        String url = new UrlBuilderHelper(DirectTestRunProperties.getInstance().getDirectHost()).getUrl(params);
        AllureUtils.addHtmlAttachment("URL", String.format("<a href=\"%s\" target=\"_blank\">%s</a>", url, url));
        config.getDriver().get(url);
    }

    public void openApiSettingsPage() {
        open(APISettingsPage.class, "open.apiSettings.page", withParameters());
    }

    @Step("Открываем страницу СМС аутентификации для API")
    public void openApiSmsAuthPage(String login) {
        open(APISmsAuthPage.class, "sms.auth", withParameters(login));
    }

    @Step("Открытие страницы копирования кампании")
    public void openCopyCampPage() {
        open(CopyCampPage.class, CopyCampPage.PAGE_NAME, withParameters());
    }

    @Step("Открываем вкладку {0} кампании {0} на странице управления кампаниями через Excel")
    public void openShowExportedXlsListPageTabFor(ExcelPageTabEnum excelPageTab, String login) {
        open(ShowExportedXlsListPage.class, "manage.in.excel.page.tab",
                withParameters(excelPageTab.getTab(), login));
    }

    @Step("Открываем страницу показа фидов для логина {0}")
    public void openShowFeedsPage(String login) {
        open(ShowFeedsPage.class, "show.feeds", withParameters(login));
    }

    @Step("Открываем страницу автопополнения")
    public void openAutoPaymentPage() {
        open(AutoPaymentPage.class, "client.autopayment", withParameters());
    }

    @Step("Открываем страницу автопополнения для логина {0}")
    public void openAutoPaymentPage(String login) {
        open(AutoPaymentPage.class, "client.autopayment.for", withParameters(login));
    }

    @Step("Открываем страницу смарт-баннеров для логина {0}")
    public void openSmartBannersPage(String login) {
        open(ShowCreativesPage.class, "open.show.creatives.for.login", withParameters(login));
    }

    @Step("Открываем промо страницу Я.Агенств")
    public void openYaAgencyPromoPage() {
        open(YandexAgenciesPromoPage.class, "yandex.agency.promo.page", withParameters());
    }

    @Step("Открываем страницу общего счета")
    public void openAccountPage() {
        open(ClientWalletPage.class, "client.wallet.page", withParameters());
    }

    @Step("Открываем страницу общего счета для клиента {0}")
    public void openAccountPageFor(String login, String agencyID) {
        open(ClientWalletPage.class, "clients.wallet.page", withParameters(login, agencyID));
    }

    @Step("Открываем страницу общего счета для клиента {0}")
    public void openAccountPageFor(String login) {
        open(ClientWalletPage.class, "clients.wallet.page.super", withParameters(login));
    }

    @Step("Открываем страницу выбора клиентов для переноса средств")
    public void openTransferStepZeroPage() {
        open(TransferStepZeroPage.class, "transfer.step.zero", withParameters());
    }

    @Step("Открываем страницу переноса средств")
    public void openTransferPage() {
        open(TransferPage.class, "transfer.page", withParameters());
    }

    @Step("Открываем страницу оплаты для кампаниий {0}")
    public void openPaymentPageFor(Long campaignId) {
        open(PaymentPage.class, "payment.page", withParameters(campaignId.toString()));
    }

    @Step("Открываем страницу оплаты для кампаниий {1} клиента {0}")
    public void openPaymentPageFor(User paymentClient, Long campaignId) {
        open(PaymentPage.class, "payment.manager.page", withParameters(campaignId.toString(),
                paymentClient.getLogin()));
    }

    @Step("Открываем страницу турболендингов для клиента {1}")
    public void openTurboLandingsPage(Long clientId) {
        open(TurboLandingsPage.class, "turbolandings.page.by.clientid", withParameters(clientId.toString()));
    }

    @Step("Открываем страницу загрузки документов для модерации")
    public void openUploadDocumentsPageForLogin(String login) {
        open(UserUploadDocumentsPage.class, "load.documents", withParameters(login));
    }
}