package ru.yandex.autotests.direct.web.steps;

import org.hamcrest.Matcher;
import org.openqa.selenium.By;

import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.autotests.direct.web.pages.alerts.Alert;
import ru.yandex.autotests.direct.web.pages.alerts.AlertBlock1;
import ru.yandex.autotests.direct.web.pages.alerts.AlertBlock2;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.annotations.WithoutScreenshot;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;
import ru.yandex.qatools.htmlelements.loader.HtmlElementLoader;

import static ru.yandex.qatools.htmlelements.matchers.WebElementMatchers.isDisplayed;
import static ru.yandex.autotests.direct.web.util.OperationSystemUtils.sleep;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
public class AlertSteps extends BaseSteps {

    private Alert alertBlock;

    private Alert getAlert() {
        sleep(5000);
        if (!config.getDriver().findElements(By.className("b-confirm")).isEmpty()) {
            alertBlock = new AlertBlock1();
        } else {
            alertBlock = new AlertBlock2();
        }
        ((ExtendedHtmlElement) alertBlock).setConfig(config);
        HtmlElementLoader.populate(alertBlock, config.getDriver());
        return alertBlock;
    }

    @Step("Подтверждаем алерт, если текст {0}")
    @WithoutScreenshot
    public void accept(Matcher<String> matcher) {
        takeScreenshot();
        Alert alertBlock = getAlert();
        alertBlock.checkText(matcher);
        alertBlock.clickYes();
    }

    @Step("Подтверждаем алерт")
    @WithoutScreenshot
    public void accept() {
        takeScreenshot();
        Alert alertBlock = getAlert();
        alertBlock.clickYes();
    }

    @Step("Закрываем алерт, если текст {0}")
    @WithoutScreenshot
    public void checkAlertAndDecline(Matcher<String> matcher) {
        takeScreenshot();
        Alert alertBlock = getAlert();
        alertBlock.checkText(matcher);
        alertBlock.clickNo();
    }

    @Step("Подтверждаем алерт, если он есть, проверяем, что текст {0}")
    @WithoutScreenshot
    public void acceptIfPresent(Matcher<String> matcher) {
        takeScreenshot();
        Alert alertBlock = getAlert();
        if (isDisplayed().matches(alertBlock)) {
            alertBlock.checkText(matcher);
            alertBlock.clickYes();
        }
    }

    @Step("Подтверждаем алерт, если текст {0}")
    @WithoutScreenshot
    public void acceptIfTextMatches(Matcher<String> matcher) {
        takeScreenshot();
        Alert alertBlock = getAlert();
        if (isDisplayed().matches(alertBlock)) {
            if (matcher.matches(alertBlock.getAlertMessage())) {
                alertBlock.clickYes();
            }
        }
    }

    @Step("Подтверждаем алерт, если он есть")
    @WithoutScreenshot
    public void acceptIfPresent() {
        takeScreenshot();
        Alert alertBlock = getAlert();
        if (isDisplayed().matches(alertBlock)) {
            alertBlock.clickYes();
        }
    }

    @Step("Закрываем алерт если текст {0}")
    @WithoutScreenshot
    public void dismiss(Matcher<String> matcher) {
        takeScreenshot();
        Alert alertBlock = getAlert();
        alertBlock.checkText(matcher);
        alertBlock.clickNo();
    }

    @Step("Закрываем алерт")
    @WithoutScreenshot
    public void dismiss() {
        takeScreenshot();
        Alert alertBlock = getAlert();
        alertBlock.clickNo();
    }

    @Step("Проверяем, что текст алерта {0}")
    @WithoutScreenshot
    public void shouldSeeAlertText(Matcher<String> matcher) {
        takeScreenshot();
        getAlert().checkText(matcher);
    }
}
