package ru.yandex.autotests.direct.web.steps;

import ru.yandex.autotests.direct.web.pages.CaptchaFormBlock;
import ru.yandex.autotests.direct.web.util.matchers.IsDisplayedMatcher;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;
import ru.yandex.qatools.htmlelements.loader.HtmlElementLoader;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

public class CaptchaFormSteps extends BaseSteps {

    private CaptchaFormBlock getCaptchaFormBlock() {
        return HtmlElementLoader.create(CaptchaFormBlock.class, config.getDriver());
    }

    @Step("Предполагаем, что показана каптча")
    public void assumeCaptchaDisplayed() {
        assumeThat("показана каптча", getCaptchaFormBlock().isCaptchaDisplayed(), equalTo(true));
    }

    @Step("Вводим капчу, если она есть")
    public void fillCaptcha() {
        getCaptchaFormBlock().fillIfDisplayed();
    }

    @Step("Вводим капчу {0}")
    public void fillCaptcha(String answer) {
        getCaptchaFormBlock().fillCaptcha(answer);
    }

    @Step("Кликаем \"Продолжить\"")
    public void clickContinue() {
        getCaptchaFormBlock().clickContinue();
    }

    @Step("Проверяем, что присутствует текст ошибки")
    public void assertErrorTextPresents() {
        assertThat("присутствует текст ошибки", getCaptchaFormBlock().getErrorText(), IsDisplayedMatcher.isDisplayed());
    }
}
